/**
 * @(#) QueryAccListReqDto.java 1.0 2018-09-19
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.account.api.dto.request.account;

import com.dtyunxi.yundt.cube.center.account.api.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author 风行
 * @since 2.0.0
 */
@ApiModel(value = "QueryAccListReqDto", description = "列表查询资金账户Dto")
public class QueryAccListReqDto extends BaseReqDto {

    @ApiModelProperty(name = "pageNum", value = "页码")
    @NotNull(message = "页码不能为空")
    private Integer pageNum;

    @ApiModelProperty(name = "pageSize", value = "每页条数")
    @NotNull(message = "每页条数不能为空")
    private Integer pageSize;

    @ApiModelProperty(name = "userType", value = "用户类型")
    private String userType;

    /**
     * 用户名
     */
    @ApiModelProperty(name = "nickName", value = "用户名")
    private String nickName;
    /**
     * 手机号
     */
    @ApiModelProperty(name = "mobile", value = "手机号")
    private String mobile;

    /**
     * 邮箱
     */
    @ApiModelProperty(name = "email", value = "邮箱")
    private String email;

    /**
     * 账户编号
     */
    @ApiModelProperty(name = "memberNo", value = "账户编号")
    private String memberNo;

    @ApiModelProperty(name = "orderByDesc", value = "降序排序字段对应变量名称")
    private String orderByDesc;
    /**
     * 用户id列表
     */
    @ApiModelProperty(name = "userIdList", value = "用户id列表")
    private List<Long> userIdList;

    /**
     * 账户类型
     */
    @ApiModelProperty(name = "accountType", value = "账户类型")
    private String accountType;

    @ApiModelProperty(name = "memberId", value = "会员Id")
    private Long memberId;

    @ApiModelProperty(name = "customerNo", value = "客户编号")
    private String customerNo ;

    @ApiModelProperty(name = "status", value = "账户状态")
    private String status ;

    @ApiModelProperty(name = "pwdStatus", value = "密码设置状态:0=未设置,1=已设置")
    private Integer pwdStatus ;

    @ApiModelProperty(name = "custKeyWord", value = "客户关键字查询")
    private String custKeyWord ;


    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getMemberNo() {
        return memberNo;
    }

    public void setMemberNo(String memberNo) {
        this.memberNo = memberNo;
    }

    public String getOrderByDesc() {
        return orderByDesc;
    }

    public void setOrderByDesc(String orderByDesc) {
        this.orderByDesc = orderByDesc;
    }

    public List<Long> getUserIdList() {
        return userIdList;
    }

    public void setUserIdList(List<Long> userIdList) {
        this.userIdList = userIdList;
    }

    public String getAccountType() {
        return accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public String getUserType() {
        return userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public String getCustomerNo() {
        return customerNo;
    }

    public void setCustomerNo(String customerNo) {
        this.customerNo = customerNo;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Integer getPwdStatus() {
        return pwdStatus;
    }

    public void setPwdStatus(Integer pwdStatus) {
        this.pwdStatus = pwdStatus;
    }

    public String getCustKeyWord() {
        return custKeyWord;
    }

    public void setCustKeyWord(String custKeyWord) {
        this.custKeyWord = custKeyWord;
    }
}
