/*
 * @(#)QueryAccPwdReqDto.java 1.0 2021年05月21日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.account.api.dto.request.account;

import com.dtyunxi.yundt.cube.center.account.api.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * <p>Title:QueryAccPwdReqDto</p>
 * <p>Description: </p>
 *
 * @author 勉之
 * @date 2021/5/21 16:12
 * @since 0.1.0
 */
@ApiModel(value = "QueryAccPwdReqDto", description = "查询资金账户密码正确Dto")
public class QueryAccPwdReqDto extends BaseReqDto {

    @ApiModelProperty(name = "oldPwd", value = "旧密码(重置密码传值)")
    private String oldPwd ;

    /**
     * 账户类型：normal (ref:com.dtyunxi.yundt.cube.center.account.api.constants.Constants.AcccountType)
     */
    @ApiModelProperty(name = "accountType", value = "账户类型")
    private String accountType;

    /**
     * 用户类型：normal ( Constants.ACCOUNT_USER_TYPE_?)
     */
    @ApiModelProperty(name = "userType", value = "用户类型")
    private String userType;

    /**
     * 用户类型对应的userId
     */
    @ApiModelProperty(name = "userId", value = "用户类型对应的userId")
    private Long userId;


    public String getOldPwd() {
        return oldPwd;
    }

    public void setOldPwd(String oldPwd) {
        this.oldPwd = oldPwd;
    }

    public String getUserType() {
        return userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    @Override
    public Long getUserId() {
        return userId;
    }

    @Override
    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getAccountType() {
        return accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

}
