package com.dtyunxi.yundt.cube.center.account.api.dto.request.account;

import com.dtyunxi.dto.RequestDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @des 充值订单
 * @author lengqian
 * @data 2019/08/05
 */
@ApiModel(value = "QueryAccountRechargeOrderReqDto", description = "账户中心-新增充值订单")
public class QueryAccountRechargeOrderReqDto extends RequestDto {
    /**
     * 订单编号
     */
    @ApiModelProperty(name = "orderNo", value = "充值单号")
    private String orderNo;
    /**
     * 用户id
     */
    @ApiModelProperty(name = "customerId", value = "用户id")
    private Long customerId;
    /**
     * 充值账户id
     */
    @ApiModelProperty(name = "accountId", value = "充值账户id")
    @NotNull(message = "充值账户id不能为空")
    private List<Long> accountIds =new ArrayList<>();
    /**
     * 终端来源类型: 1: app端 2: PC端 3:微信端
     */
    @ApiModelProperty(name = "deviceType", value = "终端来源类型:1:app端2:PC端3:微信端")
    private String deviceType;

    /**
     * 开始时间
     */
    @ApiModelProperty(name = "startDay", value = "开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startDay;
    /**
     * 结束时间
     */
    @ApiModelProperty(name = "endTime", value = "结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endDay;
    /**
     * 审核开始时间
     */
    @ApiModelProperty(name = "startAduDay", value = "审核开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startAduDay;
    /**
     * 审核结束时间
     */
    @ApiModelProperty(name = "endAduTime", value = "审核结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endAduDay;
    /**
     * 结束时间
     */
    @ApiModelProperty(name = "orderStatus", value = "订单状态STATUS_WAIT_ADU-待审核,WAIT_PAY-待支付,PAYED_SUCC-充值成功,PAYED_FAIL-充值失败")
    private String orderStatus;
    /**
     *  充值方式
     */
    @ApiModelProperty(name = "recharge_type", value = "充值方式CASH-现金支付,BANK_TRANSFER-银行转账,WE_PAY-微信支付")
    private String rechargeType;
    @ApiModelProperty(name = "userIds", value = "用户ID")
    private List<Long> userIds;

    @ApiModelProperty(name = "createUser", value = "创建人")
    private String createUser;
    @ApiModelProperty(name = "financialAdu", value = "财务审核WAIT_ADU-待审核,PASS-审核通过,REJECT-已驳回")
    private String financialAdu;

    @ApiModelProperty(name = "isOffline", value = "是否仅展示线下充值方式 1是2否")
    private Integer isOffline ;

    public String getFinancialAdu() {
        return financialAdu;
    }

    public void setFinancialAdu(String financialAdu) {
        this.financialAdu = financialAdu;
    }

    public Integer getIsOffline() {
        return isOffline;
    }

    public void setIsOffline(Integer isOffline) {
        this.isOffline = isOffline;
    }

    public Date getStartAduDay() {
        return startAduDay;
    }

    public void setStartAduDay(Date startAduDay) {
        this.startAduDay = startAduDay;
    }

    public Date getEndAduDay() {
        return endAduDay;
    }

    public void setEndAduDay(Date endAduDay) {
        this.endAduDay = endAduDay;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public String getCreateUser() {
        return createUser;
    }

    public List<Long> getAccountIds() {
        return accountIds;
    }

    public void setAccountIds(List<Long> accountIds) {
        this.accountIds = accountIds;
    }

    public String getRechargeType() {
        return rechargeType;
    }

    public void setRechargeType(String rechargeType) {
        this.rechargeType = rechargeType;
    }

    public Date getStartDay() {
        return startDay;
    }

    public void setStartDay(Date startDay) {
        this.startDay = startDay;
    }
    /**
     *  关键字:名称/编号
     */
    @ApiModelProperty(name="keyword",value = "关键字:名称/编号")
    private String keyword;

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public Date getEndDay() {
        return endDay;
    }

    public void setEndDay(Date endDay) {
        this.endDay = endDay;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }


    public String getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public void setUserIds(List<Long> userIds) {
        this.userIds = userIds;
    }

    public List<Long> getUserIds() {
        return userIds;
    }




}