/**
 * @(#) BaseTranReqDto.java 1.0 2018-09-19
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.account.api.dto.request.tran;

import com.dtyunxi.yundt.cube.center.account.api.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @author 风行
 * @since 2.0.0
 */
@ApiModel(value = "BaseTranReqDto", description = "资金操作父类Dto")
public class BaseTranReqDto extends BaseReqDto {

    /**
     * 支付类型 pay refund transfer
     */
    @ApiModelProperty(name = "tranType", value = "支付类型")
    @NotNull(message = "支付类型不能为空")
    private String tranType;

    @ApiModelProperty(name = "accountId", value = "资金帐号ID")
    private Long accountId;

    @ApiModelProperty(name = "tradeId", value = "支付流水")
    @NotNull(message = "支付流水不能为空")
    private String tradeId;


    @ApiModelProperty(name = "tranAmt", value = "交易金额")
    @NotNull(message = "交易金额不能为空")
    private BigDecimal tranAmt;

    @ApiModelProperty(name = "payType", value = "支付方式")
    private String payType;

    /**
     * 储值单据号
     */
    @ApiModelProperty(name = "code", value = "储值单据号")
    private String code;

    /**
     * 是否要更新主账号
     */
    @ApiModelProperty(name = "operSupperAccount", value = "是否要更新主账号")
    private Boolean operSupperAccount;
    @ApiModelProperty(name = "orderNo", value = "订单号")
    private String orderNo;

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getPayType() {
        return payType;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }

    public String getTranType() {
        return tranType;
    }

    public void setTranType(String tranType) {
        this.tranType = tranType;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getTradeId() {
        return tradeId;
    }

    public void setTradeId(String tradeId) {
        this.tradeId = tradeId;
    }

    public BigDecimal getTranAmt() {
        return tranAmt;
    }

    public void setTranAmt(BigDecimal tranAmt) {
        this.tranAmt = tranAmt;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Boolean getOperSupperAccount() {
        return operSupperAccount;
    }

    public void setOperSupperAccount(Boolean operSupperAccount) {
        this.operSupperAccount = operSupperAccount;
    }

    @Override
    public String toString() {
        return "BaseTranReqDto{" +
                "tranType='" + tranType + '\'' +
                ", accountId=" + accountId +
                ", tradeId='" + tradeId + '\'' +
                ", tranAmt=" + tranAmt +
                ", payType='" + payType + '\'' +
                ", code='" + code + '\'' +
                ", operSupperAccount=" + operSupperAccount +
                '}';
    }
}
