/**
 * @(#) QueryAccTranHistoryReqDto.java 1.0 2018-09-18
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.account.api.dto.request.tran;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * @author 风行
 * @since 2.0.0
 */
@ApiModel(value = "QueryAccTranHistoryReqDto", description = "交易历史记录查询Dto")
public class QueryAccTranHistoryReqDto extends BaseTranReqDto {

    @ApiModelProperty(name = "pageNum", value = "页码")
    @NotNull(message = "页码不能为空")
    private int pageNum;

    @ApiModelProperty(name = "pageSize", value = "每页条数")
    @NotNull(message = "每页条数不能为空")
    private int pageSize;



    public int getPageNum() {
        return pageNum;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
}
