/**
 * @(#) RechargeReqDto.java 1.0 2018-09-17
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.account.api.dto.request.tran;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.validation.constraints.NotNull;

/**
 * @author 风行
 * @since 0.5.0
 */
@ApiModel(value = "RechargeReqDto", description = "充值Dto")
public class RechargeReqDto extends BaseTranReqDto {

    @ApiModelProperty(name = "storeOrderId", value = "商户订单号")
    @NotNull(message = "商户订单号")
    private String storeOrderId;

    @ApiModelProperty(name = "giveAmount", value = "赠送金额")
    private String giveAmount;

    @ApiModelProperty(name = "resultFlag", value = "支付结果标志，true-成功，false-失败")
    private Boolean resultFlag;

    @ApiModelProperty(name = "rechargeType", value = "充值类型:1-用户充值,2-佣金入账充值")
    private Integer rechargeType;
    /**
     * 账户编号
     */
    @ApiModelProperty(name = "memberNo", value = "账户编号")
    private String memberNo;
    /**
     *  订单编号
     *
     */
    @Column(name = "order_no")
    private String orderNo;

    private String createPerson;

    private String updatePerson;

    public String getStoreOrderId() {
        return storeOrderId;
    }

    public void setStoreOrderId(String storeOrderId) {
        this.storeOrderId = storeOrderId;
    }

    public String getGiveAmount() {
        return giveAmount;
    }

    public void setGiveAmount(String giveAmount) {
        this.giveAmount = giveAmount;
    }

    public Boolean getResultFlag() {
        return resultFlag;
    }

    public void setResultFlag(Boolean resultFlag) {
        this.resultFlag = resultFlag;
    }

    public Integer getRechargeType() {
        return rechargeType;
    }

    public void setRechargeType(Integer rechargeType) {
        this.rechargeType = rechargeType;
    }

    public String getMemberNo() {
        return memberNo;
    }

    public void setMemberNo(String memberNo) {
        this.memberNo = memberNo;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getCreatePerson() {
        return createPerson;
    }

    public void setCreatePerson(String createPerson) {
        this.createPerson = createPerson;
    }

    public String getUpdatePerson() {
        return updatePerson;
    }

    public void setUpdatePerson(String updatePerson) {
        this.updatePerson = updatePerson;
    }

    @Override
    public String toString() {
        return "RechargeReqDto{" +
                "storeOrderId='" + storeOrderId + '\'' +
                ", giveAmount='" + giveAmount + '\'' +
                ", resultFlag=" + resultFlag +
                ", rechargeType=" + rechargeType +
                ", memberNo='" + memberNo + '\'' +
                ", orderNo='" + orderNo + '\'' +
                '}';
    }
}
