/**
 * @(#)WithdrawApplyRecordReqDto.java 1.0 2020/3/5
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.account.api.dto.request.withdraw;

import com.dtyunxi.yundt.cube.center.account.api.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * @author 伊泽
 * @since 1.0.0
 */
@ApiModel(value = "WithdrawApplyRecordReqDto", description = "提现申请单请求dto")
public class WithdrawApplyRecordReqDto extends BaseReqDto {

    @ApiModelProperty(name = "id", value = "id")
    private Long id;

    /**
     * 提现申请人员id
     */
    @ApiModelProperty(name = "applyUserId", value = "提现申请人员id", required = true)
    private Long applyUserId;

    /**
     * 佣金账户编号
     */
    @ApiModelProperty(name = "commissionAccountCode", value = "佣金账户编号")
    private String commissionAccountCode;

    /**
     * 佣金账户id
     */
    @ApiModelProperty(name = "commissionAccountId", value = "佣金账户id")
    private Long commissionAccountId;

    /**
     * 提现金额
     */
    @ApiModelProperty(name = "cashAmount", value = "提现金额", required = true)
    private BigDecimal cashAmount;

    /**
     * 提现微信号
     */
    @ApiModelProperty(name = "wxAccount", value = "提现微信号")
    private String wxAccount;

    /**
     * 申请单状态：1-待审核，2-审核中、3-审核通过，4-拒绝申请，5-已完成
     */
    @ApiModelProperty(name = "status", value = "申请单状态：1-待审核，2-审核中、3-审核通过，4-拒绝申请，5-已完成")
    private Integer status;


    @ApiModelProperty(name = "withdrawStatus", value = "提现状态： 1 待审核， 2 已拒绝 3 提现中 4 提现成功 5 提现失败")
    private Integer withdrawStatus;

    /**
     * 创建时间起始
     */
    @ApiModelProperty(name = "createTimeStart", value = "创建时间起始")
    private String createTimeStart;

    /**
     * 创建时间结束
     */
    @ApiModelProperty(name = "createTimeEnd", value = "创建时间结束")
    private String createTimeEnd;

    /**
     * 提现申请描述
     */
    @ApiModelProperty(name = "applyDesc", value = "提现申请描述")
    private String applyDesc;

    /**
     * 用户微信openId
     */
    @ApiModelProperty(name = "openid", value = "用户微信openId", required = true)
    private String openid;

    /**
     * 不是该申请单状态, 筛选未打款申请单列表需要几个状态的聚合
     */
    @ApiModelProperty(name = "notStatus", value = "不是该申请单状态，与status不同时出现，默认取status")
    private Integer notStatus;
    /**
     * 提现单号
     */
    @ApiModelProperty(name = "applyCode", value = "提现单号")
    private String applyCode;

    @ApiModelProperty(name = "accountType", value = "提现类型")
    private String accountType;

    @ApiModelProperty(name = "withdrawApplyType", value = "提现方式")
    private Integer withdrawApplyType;

    public Long getApplyUserId() {
        return applyUserId;
    }

    public void setApplyUserId(Long applyUserId) {
        this.applyUserId = applyUserId;
    }

    public String getCommissionAccountCode() {
        return commissionAccountCode;
    }

    public void setCommissionAccountCode(String commissionAccountCode) {
        this.commissionAccountCode = commissionAccountCode;
    }

    public Long getCommissionAccountId() {
        return commissionAccountId;
    }

    public void setCommissionAccountId(Long commissionAccountId) {
        this.commissionAccountId = commissionAccountId;
    }

    public BigDecimal getCashAmount() {
        return cashAmount;
    }

    public void setCashAmount(BigDecimal cashAmount) {
        this.cashAmount = cashAmount;
    }

    public String getWxAccount() {
        return wxAccount;
    }

    public void setWxAccount(String wxAccount) {
        this.wxAccount = wxAccount;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getCreateTimeStart() {
        return createTimeStart;
    }

    public void setCreateTimeStart(String createTimeStart) {
        this.createTimeStart = createTimeStart;
    }

    public String getCreateTimeEnd() {
        return createTimeEnd;
    }

    public void setCreateTimeEnd(String createTimeEnd) {
        this.createTimeEnd = createTimeEnd;
    }

    public String getApplyDesc() {
        return applyDesc;
    }

    public void setApplyDesc(String applyDesc) {
        this.applyDesc = applyDesc;
    }

    public String getOpenid() {
        return openid;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getNotStatus() {
        return notStatus;
    }

    public void setNotStatus(Integer notStatus) {
        this.notStatus = notStatus;
    }

    public String getApplyCode() {
        return applyCode;
    }

    public void setApplyCode(String applyCode) {
        this.applyCode = applyCode;
    }

    public Integer getWithdrawStatus() {
        return withdrawStatus;
    }

    public void setWithdrawStatus(Integer withdrawStatus) {
        this.withdrawStatus = withdrawStatus;
    }

    public String getAccountType() {
        return accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public Integer getWithdrawApplyType() {
        return withdrawApplyType;
    }

    public void setWithdrawApplyType(Integer withdrawApplyType) {
        this.withdrawApplyType = withdrawApplyType;
    }
}
