/**
 * @(#)WithdrawApplyRecordReqDto.java 1.0 2020/3/5
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.account.api.dto.request.withdraw;

import com.dtyunxi.yundt.cube.center.account.api.dto.request.BaseReqDto;
import com.dtyunxi.yundt.cube.center.account.api.dto.response.withdraw.WithdrawRuleRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * @des 提现申请
 * @author lengqian
 * @data 20120/03/05
 */
@ApiModel(value = "WithdrawApplyReqDto", description = "提现申请单请求dto")
public class WithdrawApplyReqDto extends BaseReqDto {

    /**
     * 提现申请类型:1-提现到微信,2-提现到支付宝,3-提现到银行卡
     */
    @ApiModelProperty(name = "withdrawApplyType", value = "提现申请类型:1-提现到微信,2-提现到支付宝,3-提现到银行卡", required = true)
    private Integer withdrawApplyType;

    /**
     * 提现申请人员id
     */
    @ApiModelProperty(name = "applyUserId", value = "提现申请人员id", required = true)
    private Long applyUserId;

    @ApiModelProperty(name = "memberId", value = "会员ID", required = true)
    private Long memberId;

    /**
     * 提现金额
     */
    @ApiModelProperty(name = "cashAmount", value = "提现金额", required = true)
    private BigDecimal cashAmount;

    /**
     * 提现申请描述
     */
    @ApiModelProperty(name = "applyDesc", value = "提现申请描述")
    private String applyDesc;

    /**
     * 用户微信openId
     */
    @ApiModelProperty(name = "openid", value = "用户微信openId", required = true)
    private String openid;

    @ApiModelProperty(name = "accountType", value = "提现账户类型")
    private String accountType;

    @ApiModelProperty(name = "withdrawRule", value = "提现规则")
    private WithdrawRuleRespDto withdrawRule;

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public Integer getWithdrawApplyType() {
        return withdrawApplyType;
    }

    public void setWithdrawApplyType(Integer withdrawApplyType) {
        this.withdrawApplyType = withdrawApplyType;
    }

    public Long getApplyUserId() {
        return applyUserId;
    }

    public void setApplyUserId(Long applyUserId) {
        this.applyUserId = applyUserId;
    }

    public BigDecimal getCashAmount() {
        return cashAmount;
    }

    public void setCashAmount(BigDecimal cashAmount) {
        this.cashAmount = cashAmount;
    }

    public String getApplyDesc() {
        return applyDesc;
    }

    public void setApplyDesc(String applyDesc) {
        this.applyDesc = applyDesc;
    }

    public String getOpenid() {
        return openid;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public String getAccountType() {
        return accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public WithdrawRuleRespDto getWithdrawRule() {
        return withdrawRule;
    }

    public void setWithdrawRule(WithdrawRuleRespDto withdrawRule) {
        this.withdrawRule = withdrawRule;
    }
}
