/**
 * @(#)WithdrawApplyRecordReqDto.java 1.0 2020/3/5
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.account.api.dto.request.withdraw;

import com.dtyunxi.yundt.cube.center.account.api.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @des 提现申请
 * @author lengqian
 * @data 20120/03/05
 */
@ApiModel(value = "WithdrawConfirmReqDto", description = "提现申请单确认请求dto")
public class WithdrawConfirmReqDto extends BaseReqDto {

    /**
     * 提现申请类型:1-提现到微信,2-提现到支付宝,3-提现到银行卡
     */
    @ApiModelProperty(name = "withdrawApplyType", value = "提现申请类型:1-提现到微信,2-提现到支付宝,3-提现到银行卡", required = true)
    private Integer withdrawApplyType;

    /**
     * 提现申请单id
     */
    @ApiModelProperty(name = "applyId", value = "提现申请单id", required = true)
    private Long applyId;

    public Long getApplyId() {
        return applyId;
    }

    public void setApplyId(Long applyId) {
        this.applyId = applyId;
    }

    public Integer getWithdrawApplyType() {
        return withdrawApplyType;
    }

    public void setWithdrawApplyType(Integer withdrawApplyType) {
        this.withdrawApplyType = withdrawApplyType;
    }
}
