/**
 * @(#)WithdrawApplyRecordReqDto.java 1.0 2020/3/5
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.account.api.dto.request.withdraw;

import com.dtyunxi.yundt.cube.center.account.api.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * @author lengqian
 * @des 提现申请
 * @data 20120/03/05
 */
@ApiModel(value = "WithdrawDoReqDto", description = "提现申请单请求dto")
public class WithdrawDoReqDto extends BaseReqDto {

    /**
     * 提现申请类型:1-提现到微信,2-提现到支付宝,3-提现到银行卡
     */
    @ApiModelProperty(name = "withdrawApplyType", value = "提现申请类型:1-提现到微信,2-提现到支付宝,3-提现到银行卡", required = true)
    private Integer withdrawApplyType;

    /**
     * 提现申请单id
     */
    @ApiModelProperty(name = "applyId", value = "提现申请单id", required = true)
    @NotNull(message = "提现ID不能为空")
    private Long applyId;

    public Long getApplyId() {
        return applyId;
    }

    public void setApplyId(Long applyId) {
        this.applyId = applyId;
    }

    public Integer getWithdrawApplyType() {
        return withdrawApplyType;
    }

    public void setWithdrawApplyType(Integer withdrawApplyType) {
        this.withdrawApplyType = withdrawApplyType;
    }
}
