/**
 * @(#)WithdrawApplyRecordReqDto.java 1.0 2020/3/5
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.account.api.dto.request.withdraw;

import com.dtyunxi.yundt.cube.center.account.api.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * 增加提现规则DTO
 */
@ApiModel(value = "WithdrawRuleReqDto", description = "增加提现规则DTO")
public class WithdrawRuleReqDto extends BaseReqDto {

    @ApiModelProperty(name = "id", value = "主键ID")
    private Long id;

    @ApiModelProperty(name = "accountType", value = "账户类型", required = true)
    @NotNull(message = "账户类型不呢为空")
    private String accountType;

    @ApiModelProperty(name = "singleMaxAmount", value = "单次最大提现金额")
    private BigDecimal singleMaxAmount;

    @ApiModelProperty(name = "singleMinAmount", value = "单次最小提现金额")
    private BigDecimal singleMinAmount;

    @ApiModelProperty(name = "countLimit", value = "单日最多提现次数限制")
    @Min(value = 0)
    private Integer countLimit;

    @ApiModelProperty(name = "taxRate", value = "税费比例")
    private BigDecimal taxRate;

    @ApiModelProperty(name = "feeRate", value = "服务费比例")
    private BigDecimal feeRate;

    @ApiModelProperty(name = "remark", value = "文案展示")
    private String remark;

    @ApiModelProperty(name = "updatePerson", value = "修改人")
    private String updatePerson;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAccountType() {
        return accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public BigDecimal getSingleMaxAmount() {
        return singleMaxAmount;
    }

    public void setSingleMaxAmount(BigDecimal singleMaxAmount) {
        this.singleMaxAmount = singleMaxAmount;
    }

    public BigDecimal getSingleMinAmount() {
        return singleMinAmount;
    }

    public void setSingleMinAmount(BigDecimal singleMinAmount) {
        this.singleMinAmount = singleMinAmount;
    }

    public Integer getCountLimit() {
        return countLimit;
    }

    public void setCountLimit(Integer countLimit) {
        this.countLimit = countLimit;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getFeeRate() {
        return feeRate;
    }

    public void setFeeRate(BigDecimal feeRate) {
        this.feeRate = feeRate;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getUpdatePerson() {
        return updatePerson;
    }

    public void setUpdatePerson(String updatePerson) {
        this.updatePerson = updatePerson;
    }
}
