/**
 * @(#)WithdrawApplyRecordReqDto.java 1.0 2020/3/5
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.account.api.dto.request.withdraw;

import com.dtyunxi.yundt.cube.center.account.api.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 提现单修改DTO
 */
@ApiModel(value = "WithdrawUpdateReqDto", description = "提现单修改DTO")
public class WithdrawUpdateReqDto extends BaseReqDto {

    @ApiModelProperty(name = "applyCode", value = "提现单号", required = true)
    @NotNull(message = "提现单号不能为空")
    private String applyCode;

    @ApiModelProperty(name = "withdrawStatus", value = "提现状态")
    private Integer withdrawStatus;

    @ApiModelProperty(name = "paymentNo", value = "提现转账单号")
    private String paymentNo;

    @ApiModelProperty(name = "paymentTime", value = "提现转账时间")
    private Date paymentTime;


    public String getApplyCode() {
        return applyCode;
    }

    public void setApplyCode(String applyCode) {
        this.applyCode = applyCode;
    }

    public Integer getWithdrawStatus() {
        return withdrawStatus;
    }

    public void setWithdrawStatus(Integer withdrawStatus) {
        this.withdrawStatus = withdrawStatus;
    }

    public String getPaymentNo() {
        return paymentNo;
    }

    public void setPaymentNo(String paymentNo) {
        this.paymentNo = paymentNo;
    }

    public Date getPaymentTime() {
        return paymentTime;
    }

    public void setPaymentTime(Date paymentTime) {
        this.paymentTime = paymentTime;
    }
}
