/**
 * @(#)AccountFlowReqDto.java 1.0 2020/3/4
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.account.api.dto.response.account;

import com.dtyunxi.yundt.cube.center.account.api.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 账户流水
 *
 * @author wu.sheng
 * @date 2020/3/4 11:22
 */
@ApiModel(value = "AccountFlowQueryRespDto", description = "账户流水查询参数")
public class AccountFlowQueryRespDto extends BaseReqDto {

    @ApiModelProperty(name = "id", value = "id")
    private Long id;
    @ApiModelProperty(name = "returnOrderNo", value = "退订单")
    private String returnOrderNo;
    /**
     * 账户Id
     */
    @ApiModelProperty(name = "accountId", value = "账户Id")
    private Long accountId;

    /**
     * 变更类型（01=充值、02=支付、03=充值冲正、04=支付冲正、05=退款/06=赠送积分）
     */
    @ApiModelProperty(name = "changeType", value = "01=充值、02=支付、03=充值冲正、04=支付冲正、05=退款/06=赠送积分")
    private String changeType;


    @ApiModelProperty(name = "changeTypeDesc", value = "交易类型枚举:充值、支付、退款")
    private String changeTypeDesc;


    /**
     * 账户编号
     */
    @ApiModelProperty(name = "memberNo", value = "账户编号")
    private String memberNo;

    /**
     * 流水
     */
    @ApiModelProperty(name = "tradeId", value = "账户流水号")
    private String tradeId;


    /**
     * 订单编号
     */
    @ApiModelProperty(name = "orderNo", value = "订单号")
    private String orderNo;

    @ApiModelProperty(name = "tradeAmount", value = "交易金额")
    private BigDecimal tradeAmount;

    @ApiModelProperty(name = "createTime", value = "创建时间")
    private Date createTime;

    @ApiModelProperty(name = "channelCode", value = "渠道编码")
    private String channelCode;

    @ApiModelProperty(name = "code", value = "单据号")
    private String code;

    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    @ApiModelProperty(name = "createPerson", value = "操作人")
    private String createPerson;

    @ApiModelProperty(name = "businessDate", value = "交易时间")
    private Date businessDate ;

    @ApiModelProperty(name = "nickName", value = "客户名称")
    private String nickName ;

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public String getReturnOrderNo() {
        return returnOrderNo;
    }

    public void setReturnOrderNo(String returnOrderNo) {
        this.returnOrderNo = returnOrderNo;
    }

    public String getMemberNo() {
        return memberNo;
    }

    public void setMemberNo(String memberNo) {
        this.memberNo = memberNo;
    }

    public String getTradeId() {
        return tradeId;
    }

    public void setTradeId(String tradeId) {
        this.tradeId = tradeId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public BigDecimal getTradeAmount() {
        return tradeAmount;
    }

    public void setTradeAmount(BigDecimal tradeAmount) {
        this.tradeAmount = tradeAmount;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getCreatePerson() {
        return createPerson;
    }

    public void setCreatePerson(String createPerson) {
        this.createPerson = createPerson;
    }

    public Date getBusinessDate() {
        return businessDate;
    }

    public void setBusinessDate(Date businessDate) {
        this.businessDate = businessDate;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getChangeTypeDesc() {
        return changeTypeDesc;
    }

    public void setChangeTypeDesc(String changeTypeDesc) {
        this.changeTypeDesc = changeTypeDesc;
    }
}
