/*
 * @(#)AccountFlowQuerySumRespDto.java 1.0 2021年05月24日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.account.api.dto.response.account;

import com.dtyunxi.yundt.cube.center.account.api.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>Title:AccountFlowQuerySumRespDto</p>
 * <p>Description: </p>
 *
 * @author 勉之
 * @date 2021/5/24 17:05
 * @since 0.1.0
 */
@ApiModel(value = "AccountFlowQuerySumRespDto", description = "账户流水交易类型统计值返回")
public class AccountFlowQuerySumRespDto extends BaseReqDto {

    /**
     * 账户Id
     */
    @ApiModelProperty(name = "accountId", value = "账户Id")
    private Long accountId;

    /**
     * 账户编号
     */
    @ApiModelProperty(name = "memberNo", value = "账户编号")
    private String memberNo;

    /**
     * 交易类型统计值
     */
    @ApiModelProperty(name = "changeTypeSumMap", value = "不同交易类型统计值")
    private Map<String,BigDecimal> changeTypeSumMap = new HashMap<String,BigDecimal>();


    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getMemberNo() {
        return memberNo;
    }

    public void setMemberNo(String memberNo) {
        this.memberNo = memberNo;
    }

    public Map<String, BigDecimal> getChangeTypeSumMap() {
        return changeTypeSumMap;
    }

    public void setChangeTypeSumMap(Map<String, BigDecimal> changeTypeSumMap) {
        this.changeTypeSumMap = changeTypeSumMap;
    }

}
