/**
 * @(#) QueryAccRespDto.java 1.0 2018-09-18
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.account.api.dto.response.account;

import com.dtyunxi.yundt.cube.center.account.api.dto.response.BaseRespDto;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author 风行
 * @since 2.0.0
 */
public class QueryAccRespDto extends BaseRespDto {

    /**
     * 账户Id
     */
    @ApiModelProperty(name = "accountId", value = "账户Id")
    private Long accountId;

    @ApiModelProperty(name = "memberId", value = "会员ID")
    private Long memberId;

    /**
     * 余额
     */
    @ApiModelProperty(name = "balance", value = "余额")
    private BigDecimal balance;

    /**
     * 已冻结金额
     */
    @ApiModelProperty(name = "frozen", value = "已冻结金额")
    private BigDecimal frozen;

    /**
     * 可支配金额(可提现， 可支付)
     */
    @ApiModelProperty(name = "disposable", value = "可支配金额(可提现， 可支付)")
    private BigDecimal disposable;

    /**
     * 联系手机
     */
    @ApiModelProperty(name = "mobile", value = "手机号码")
    private String mobile;

    /**
     * 用户类型
     */
    @ApiModelProperty(name = "userType", value = "用户类型")
    private String userType;
    /**
     * 用户名：无效对应属性..
     */
    @ApiModelProperty(name = "userName", value = "用户名")
    private String userName;

    /**
     * 客户名称：对应字段nick_name
     */
    @ApiModelProperty(name = "nickName", value = "客户名称")
    private String nickName;

    /**
     * 状态 ENABLED可用 LOCK锁定 FORBIDEN禁用
     */
    @ApiModelProperty(name = "status", value = "状态")
    private String status;

    /**
     * 邮箱
     */
    @ApiModelProperty(name = "email", value = "邮箱")
    private String email;

    /**
     * 帐号类型
     */
    @ApiModelProperty(name = "accountType", value = "账户类型")
    private String accountType;

    /**
     * 租户id
     */
    @ApiModelProperty(name = "tenantId", value = "租户Id")
    private Long tenantId;

    /**
     * 实例id
     */
    @ApiModelProperty(name = "instanceId", value = "实例id")
    private Long instanceId;

    /**
     * 账户编号
     */
    @ApiModelProperty(name = "memberNo", value = "账户编号")
    private String memberNo;

    /**
     * 客户编号
     */
    @ApiModelProperty(name = "customerNo", value = "客户编号")
    private String customerNo;

    /**
     * 客户子分类
     */
    @ApiModelProperty(name = "userSubType", value = "客户子分类")
    private String userSubType;


    @ApiModelProperty(name = "createTime", value = "创建时间")
    private Date createTime;

    @ApiModelProperty(name = "createTime", value = "密码状态:未设置：已设置")
    private String pwdStatusStr ;


    @ApiModelProperty(name = "pwdStatus", value = "密码状态:0未设置：1已设置")
    private Integer pwdStatus ;


    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public BigDecimal getFrozen() {
        return frozen;
    }

    public void setFrozen(BigDecimal frozen) {
        this.frozen = frozen;
    }

    public BigDecimal getDisposable() {
        return disposable;
    }

    public void setDisposable(BigDecimal disposable) {
        this.disposable = disposable;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getUserType() {
        return userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getAccountType() {
        return accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public String getMemberNo() {
        return memberNo;
    }

    public void setMemberNo(String memberNo) {
        this.memberNo = memberNo;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getCustomerNo() {
        return customerNo;
    }

    public void setCustomerNo(String customerNo) {
        this.customerNo = customerNo;
    }

    public String getUserSubType() {
        return userSubType;
    }

    public void setUserSubType(String userSubType) {
        this.userSubType = userSubType;
    }

    public String getPwdStatusStr() {
        return pwdStatusStr;
    }

    public void setPwdStatusStr(String pwdStatusStr) {
        this.pwdStatusStr = pwdStatusStr;
    }

    public Integer getPwdStatus() {
        return pwdStatus;
    }

    public void setPwdStatus(Integer pwdStatus) {
        this.pwdStatus = pwdStatus;
    }

}
