package com.dtyunxi.yundt.cube.center.account.api.dto.response.account;

import com.dtyunxi.yundt.cube.center.account.api.dto.request.account.AttachmentReqDto;
import com.dtyunxi.yundt.cube.center.account.api.dto.response.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @des 账户中心-充值订单
 * @author lengqian
 * @data 2019/08/05
 */
@ApiModel(value = "QueryAccountRechargeOrderRespDto", description = "账户中心-充值订单")
public class QueryAccountRechargeOrderRespDto extends BaseRespDto {

    /**
     *  充值订单号
     */
    @ApiModelProperty(name = "orderNo", value = "订单号/充值单号")
    private String orderNo;
    /**
     * 充值账户id
     */
    private Long accountId;
    /**
     * 订单状态：WAIT_PAY:待付款(默认),PAYING:付款中,PAYED_SUCC: 付款成功，PAYED_FAIL: 付款失败,CANCEL:订单取消,REFUND:订单退款
     */
    private String orderStatus;
    private String orderStatusName;
    @ApiModelProperty(name = "rechargeType", value = "支付方式/充值方式")
    private String rechargeType;

    @ApiModelProperty(name = "rechargeTypeName", value = "支付方式/充值方式")
    private String rechargeTypeName;
    /**
     * 赠送金额
     */
    private BigDecimal giveAmount;
    /**
     * 实付金额
     */
    @ApiModelProperty(name = "payAmount", value = "实付金额")
    private BigDecimal payAmount;
    /**
     * 充值金额（充值金额=赠送金额+实付金额）
     */
    @ApiModelProperty(name = "totalAmount", value = "充值金额（充值金额=赠送金额+实付金额）")
    private BigDecimal totalAmount;
    /**
     * 买家备注
     */
    @ApiModelProperty(name = "buyerRemark", value = "买家备注")
    private String buyerRemark;
    @ApiModelProperty(name = "financialAduTime", value = "财务审核时间[2021-5-24 14:27:26)]")
    private String financialAduTime;
    /**
     * 审核状态
     */
    @ApiModelProperty(name = "financialAdu", value = "财务审核状态")
    private String financialAdu;
    /**
     * 财务审核状态
     */
    @ApiModelProperty(name = "financialAduName", value = "财务审核状态")
    private String financialAduName;
    /**
     * 卖家备注
     */
    private String sellerRemark;
    /**
     * 订单关闭时间
     */
    private Date closeTime;
    /**
     * 终端来源类型: 1: app端 2: PC端 3:微信端
     */
    private String deviceType;
    /**
     * 创建时间格式[5月24日 14:08]
     */
    @ApiModelProperty(name = "createTime", value = "创建时间格式[5月24日 14:08]")
    private String createTime;
    /**
     * 格式为 [2021-5-24 14:07:35]
     * Created by sumo on 2021/5/24
     */
    @ApiModelProperty(name = "createTimeLong", value = "创建时间格式 格式为 [2021-5-24 14:07:35]")
    private String createTimeLong;
    private String createPerson;
    @ApiModelProperty(name = "customerNo", value = "客户编码")
    private String customerNo;
    @ApiModelProperty(name = "nickName", value = "客户名")
    private String nickName;
    @ApiModelProperty(name = "paySuccessTime", value = "付款时间")
    private String paySuccessTime;
    /**
     * 付款方户名
     */
    @ApiModelProperty(name="payAccountName", value = "付款方户名")
    private String payAccountName;
    @ApiModelProperty(name="isRefer", value = "是否代客下单1是0否")
    private Integer isRefer;

    public String getFinancialAduTime() {
        return financialAduTime;
    }

    public void setFinancialAduTime(String financialAduTime) {
        this.financialAduTime = financialAduTime;
    }

    /**
     * 付款方账号
     */
    @ApiModelProperty(name="payAccountNo", value = "付款方账号")
    private String payAccountNo;


    @ApiModelProperty(name = "attachmentList", value = "附件")
    List<AttachmentReqDto> attachmentList;
    @ApiModelProperty(name = "createPersonName", value = "创建人名称")
    private String createPersonName;

    public List<AttachmentReqDto> getAttachmentList() {
        return attachmentList;
    }

    public void setAttachmentList(List<AttachmentReqDto> attachmentList) {
        this.attachmentList = attachmentList;
    }

    public String getFinancialAdu() {
        return financialAdu;
    }

    public void setFinancialAdu(String financialAdu) {
        this.financialAdu = financialAdu;
    }

    public String getFinancialAduName() {
        return financialAduName;
    }

    public void setFinancialAduName(String financialAduName) {
        this.financialAduName = financialAduName;
    }

    public String getPaySuccessTime() {
        return paySuccessTime;
    }

    public void setPaySuccessTime(String paySuccessTime) {
        this.paySuccessTime = paySuccessTime;
    }

    public String getPayAccountName() {
        return payAccountName;
    }

    public void setPayAccountName(String payAccountName) {
        this.payAccountName = payAccountName;
    }

    public String getPayAccountNo() {
        return payAccountNo;
    }

    public void setPayAccountNo(String payAccountNo) {
        this.payAccountNo = payAccountNo;
    }

    public String getRechargeType() {
        return rechargeType;
    }

    public void setRechargeType(String rechargeType) {
        this.rechargeType = rechargeType;
    }

    public String getRechargeTypeName() {
        return rechargeTypeName;
    }

    public void setRechargeTypeName(String rechargeTypeName) {
        this.rechargeTypeName = rechargeTypeName;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public String getOrderStatusName() {
        return orderStatusName;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public void setOrderStatusName(String orderStatusName) {
        this.orderStatusName = orderStatusName;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public BigDecimal getGiveAmount() {
        return giveAmount;
    }

    public void setGiveAmount(BigDecimal giveAmount) {
        this.giveAmount = giveAmount;
    }

    public BigDecimal getPayAmount() {
        return payAmount;
    }

    public void setPayAmount(BigDecimal payAmount) {
        this.payAmount = payAmount;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getBuyerRemark() {
        return buyerRemark;
    }

    public void setBuyerRemark(String buyerRemark) {
        this.buyerRemark = buyerRemark;
    }

    public String getSellerRemark() {
        return sellerRemark;
    }

    public void setSellerRemark(String sellerRemark) {
        this.sellerRemark = sellerRemark;
    }

    public Date getCloseTime() {
        return closeTime;
    }

    public void setCloseTime(Date closeTime) {
        this.closeTime = closeTime;
    }

    public String getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public void setCreateTimeLong(String createTimeLong) {
        this.createTimeLong = createTimeLong;
    }

    public String getCreateTimeLong() {
        return createTimeLong;
    }

    public void setCreatePerson(String createPerson) {
        this.createPerson = createPerson;
    }

    public String getCreatePerson() {
        return createPerson;
    }

    public void setCustomerNo(String customerNo) {
        this.customerNo = customerNo;
    }

    public String getCustomerNo() {
        return customerNo;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getNickName() {
        return nickName;
    }

    public void setCreatePersonName(String createPersonName) {
        this.createPersonName = createPersonName;
    }

    public String getCreatePersonName() {
        return createPersonName;
    }

    public void setIsRefer(Integer isRefer) {
        this.isRefer = isRefer;
    }

    public Integer getIsRefer() {
        return isRefer;
    }
}