/**
 * @(#)WithdrawApplyRecordRespDto.java 1.0 2020/3/5
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.account.api.dto.response.withdraw;

import com.dtyunxi.yundt.cube.center.account.api.dto.response.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author 伊泽
 * @since 1.0.0
 */
@ApiModel(value = "WithdrawApplyRecordRespDto", description = "提现申请单响应dto")
public class WithdrawApplyRecordRespDto extends BaseRespDto {

    /**
     * 提现申请人员id
     */
    @ApiModelProperty(name = "applyUserId", value = "提现申请人员id")
    private Long applyUserId;

    /**
     * 佣金账户编号
     */
    @ApiModelProperty(name = "commissionAccountCode", value = "佣金账户编号")
    private String commissionAccountCode;

    /**
     * 提现金额
     */
    @ApiModelProperty(name = "cashAmount", value = "提现金额")
    private BigDecimal cashAmount;

    @ApiModelProperty(name = "arrivalAmount", value = "到账金额")
    private BigDecimal arrivalAmount;

    @ApiModelProperty(name = "taxAmount", value = "税费")
    private BigDecimal taxAmount;

    @ApiModelProperty(name = "feeAmount", value = "服务费")
    private BigDecimal feeAmount;

    /**
     * 提现微信号
     */
    @ApiModelProperty(name = "wxAccount", value = "提现微信号")
    private String wxAccount;

    /**
     * 申请单状态：1-待审核，2-审核中、3-审核通过，4-拒绝申请，5-已完成
     */
    @ApiModelProperty(name = "status", value = "申请单状态：1-待审核，2-审核中、3-审核通过，4-拒绝申请，5-已完成")
    private Integer status;


    @ApiModelProperty(name = "withdrawStatus", value = "提现状态： 1 待审核， 2 已拒绝 3 提现中 4 提现成功 5 提现失败")
    private Integer withdrawStatus;

    /**
     * 提现申请描述
     */
    @ApiModelProperty(name = "applyDesc", value = "提现申请描述")
    private String applyDesc;

    /**
     * 版本号
     */
    @ApiModelProperty(name = "version", value = "版本号")
    private Short version;

    /**
     * 实例id
     */
    @ApiModelProperty(name = "instanceId", value = "实例id")
    private Long instanceId;

    /**
     * 租户id
     */
    @ApiModelProperty(name = "tenantId", value = "租户id")
    private Long tenantId;

    /**
     * 创建时间
     */
    @ApiModelProperty(name = "createTime", value = "创建时间")
    private Date createTime;

    /**
     * 提现单号
     */
    @ApiModelProperty(name = "applyCode", value = "提现单号")
    private String applyCode;

    @ApiModelProperty(name = "accountType", value = "提现类型")
    private String accountType;

    @ApiModelProperty(name = "withdrawApplyType", value = "提现方式")
    private Integer withdrawApplyType;


    public Long getApplyUserId() {
        return applyUserId;
    }

    public void setApplyUserId(Long applyUserId) {
        this.applyUserId = applyUserId;
    }

    public String getCommissionAccountCode() {
        return commissionAccountCode;
    }

    public void setCommissionAccountCode(String commissionAccountCode) {
        this.commissionAccountCode = commissionAccountCode;
    }

    public BigDecimal getCashAmount() {
        return cashAmount;
    }

    public void setCashAmount(BigDecimal cashAmount) {
        this.cashAmount = cashAmount;
    }

    public String getWxAccount() {
        return wxAccount;
    }

    public void setWxAccount(String wxAccount) {
        this.wxAccount = wxAccount;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getApplyDesc() {
        return applyDesc;
    }

    public void setApplyDesc(String applyDesc) {
        this.applyDesc = applyDesc;
    }

    public Short getVersion() {
        return version;
    }

    public void setVersion(Short version) {
        this.version = version;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getApplyCode() {
        return applyCode;
    }

    public void setApplyCode(String applyCode) {
        this.applyCode = applyCode;
    }

    public Integer getWithdrawStatus() {
        return withdrawStatus;
    }

    public void setWithdrawStatus(Integer withdrawStatus) {
        this.withdrawStatus = withdrawStatus;
    }

    public String getAccountType() {
        return accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public BigDecimal getArrivalAmount() {
        return arrivalAmount;
    }

    public void setArrivalAmount(BigDecimal arrivalAmount) {
        this.arrivalAmount = arrivalAmount;
    }

    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public BigDecimal getFeeAmount() {
        return feeAmount;
    }

    public void setFeeAmount(BigDecimal feeAmount) {
        this.feeAmount = feeAmount;
    }

    public Integer getWithdrawApplyType() {
        return withdrawApplyType;
    }

    public void setWithdrawApplyType(Integer withdrawApplyType) {
        this.withdrawApplyType = withdrawApplyType;
    }
}
