/*
 * @(#)ChangeTypeEnum.java 1.0 2021年05月25日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.account.api.enums;

import com.dtyunxi.yundt.cube.center.account.api.constants.Constants;
import com.dtyunxi.yundt.cube.center.account.api.dto.response.account.AccountFlowChangeTypeRespDto;
import com.google.common.collect.Lists;

import java.util.List;

/**
 * <p>Title:ChangeTypeEnum</p>
 * <p>Description: 账户资金交易类型 </p>
 *
 * @author 勉之
 * @date 2021/5/25 9:00
 * @since 0.1.0
 */
public enum ChangeTypeEnum {

    TYPE_RECHARGE(Constants.ACCOUNT_BALANCE_OP_TYPE_RECHARGE,"充值"),
    TYPE_PAY(Constants.ACCOUNT_BALANCE_OP_TYPE_PAY,"支付"),
    TYPE_REFUND(Constants.ACCOUNT_BALANCE_OP_TYPE_REFUND,"退款")
    ;

    static List<AccountFlowChangeTypeRespDto> changeTypeList = Lists.newArrayList();
    static {
        changeTypeList.add(new AccountFlowChangeTypeRespDto(TYPE_RECHARGE.getCode()
                ,TYPE_RECHARGE.getName() ));
        changeTypeList.add(new AccountFlowChangeTypeRespDto(TYPE_PAY.getCode()
                ,TYPE_PAY.getName() ));
        changeTypeList.add(new AccountFlowChangeTypeRespDto(TYPE_REFUND.getCode()
                ,TYPE_REFUND.getName() ));
    }

    private final String code;
    private final String name;

    ChangeTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static ChangeTypeEnum fromCode(String code) {
        for (ChangeTypeEnum typeEnum : ChangeTypeEnum.values()) {
            if (typeEnum.getCode().equals(code)) {
                return typeEnum;
            }
        }
        return null;
    }

    public static List<AccountFlowChangeTypeRespDto> getChangeTypeList(){
        return changeTypeList;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

}
