package com.dtyunxi.yundt.cube.center.account.api.enums;


/**
 * 财务审核状态
 *
 * @author sumo on 2020/10/13 0013
 */
public enum FinancialAduEnum {

    /**
     * 财务审核状态 - WAIT_ADU-待审核,PASS-审核通过,REJECT-已驳回
     */
    WAIT_ADU("WAIT_ADU", "待审核"),
    PASS("PASS", "审核通过"),
    REJECT("REJECT", "已驳回"),

    ;

    private final String code;
    private final String name;

    FinancialAduEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static FinancialAduEnum fromCode(String status) {
        for (FinancialAduEnum typeEnum : FinancialAduEnum.values()) {
            if (typeEnum.getCode().equals(status)) {
                return typeEnum;
            }
        }
        return null;
    }

    public static String toCode(String status) {
        FinancialAduEnum importStatusEnum = fromCode(status);
        return importStatusEnum == null ? null : importStatusEnum.getCode();
    }

    public static String toName(String status) {
        FinancialAduEnum importStatusEnum = fromCode(status);
        return importStatusEnum == null ? null : importStatusEnum.getName();
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
