/*
 * @(#)WithDrawStepEnum.java 1.0 2018-10-30
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.account.api.enums;

/**
 * @author lengqian
 * @des 充值订单状态枚举
 * @data 2019/08/07
 */
public enum RechargeOrderStatusEnum {

    /**
     * 订单状态：WAIT_PAY:待付款(默认)
     */
    STATUS_WAIT_PAY("WAIT_PAY", "待付款(默认)"),
    /**
     * 订单状态：PAYING:付款中
     */
    STATUS_PAYING("PAYING", "付款中"),

    /**
     * 订单状态：PAYED_SUCC: 付款成功
     */
    STATUS_PAYED_SUCC("PAYED_SUCC", "付款成功"),
    /**
     * 订单状态：PAYED_FAIL: 付款失败
     */
    STATUS_PAYED_FAIL("PAYED_FAIL", "付款失败"),
    /**
     * 订单状态：CANCEL:订单取消
     */
    STATUS_CANCEL("CANCEL", "订单取消"),
    /**
     * 订单状态：REFUND:订单退款
     */
    STATUS_REFUND("REFUND", "订单退款"),
    /**
     * 订单状态：OVERDUE:订单逾期
     */
    STATUS_OVERDUE("OVERDUE", "订单逾期"),

    ;

    private String status;
    private String desc;

    RechargeOrderStatusEnum(String status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public String getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }

    public static RechargeOrderStatusEnum fromCode(String status) {
        for (RechargeOrderStatusEnum typeEnum : RechargeOrderStatusEnum.values()) {
            if (typeEnum.getStatus().equals(status)) {
                return typeEnum;
            }
        }
        return null;
    }



    public static String toName(String status) {
        RechargeOrderStatusEnum importStatusEnum = fromCode(status);
        return importStatusEnum == null ? null : importStatusEnum.getDesc();
    }


}
