/*
 * @(#)WithDrawStepEnum.java 1.0 2018-10-30
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.account.api.enums;

/**
 * @author lengqian
 * @des 充值订单状态枚举 TOB 用  STATUS_WAIT_ADU-待审核,WAIT_PAY-待支付,PAYED_SUCC-充值成功,PAYED_FAIL-充值失败
 * @data 2019/08/07
 */
public enum RechargeOrderStatusToBEnum {


    /**
     * 订单状态：WAIT_PAY:待付款(默认)
     */
    STATUS_WAIT_PAY(RechargeOrderStatusEnum.STATUS_WAIT_PAY.getStatus(), "待支付"),

    /**
     * 订单状态：PAYING:付款中
     */
    STATUS_PAYING("PAYING", "付款中"),
    /**
     * 订单状态:STATUS_WAIT_ADU:待审核
     */
    STATUS_WAIT_ADU("WAIT_ADU", "待审核"),
    /**
     * 订单状态：PAYED_SUCC: 充值成功
     */
    STATUS_PAYED_SUCC(RechargeOrderStatusEnum.STATUS_PAYED_SUCC.getStatus(), "充值成功"),

    /**
     * 订单状态：PAYED_FAIL: 充值失败
     */
    STATUS_PAYED_FAIL(RechargeOrderStatusEnum.STATUS_PAYED_FAIL.getDesc(), "充值失败"),

    /**
     * 订单状态：RECEIVE_MONEY: 充值已到账
     */
    RECEIVE_MONEY(RechargeOrderStatusEnum.STATUS_WAIT_PAY.getStatus(), "充值已到账"),

    /**
     * 订单状态：CANCEL:订单取消
     */
    STATUS_CANCEL(RechargeOrderStatusEnum.STATUS_CANCEL.getStatus(), "订单取消"),


    ;

    private String status;
    private String desc;

    RechargeOrderStatusToBEnum(String status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public static RechargeOrderStatusToBEnum fromCode(String status) {
        for (RechargeOrderStatusToBEnum typeEnum : RechargeOrderStatusToBEnum.values()) {
            if (typeEnum.getStatus().equals(status)) {
                return typeEnum;
            }
        }
        return null;
    }

    public static String toName(String status) {
        RechargeOrderStatusToBEnum importStatusEnum = fromCode(status);
        return importStatusEnum == null ? null : importStatusEnum.getDesc();
    }

    public String getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }


}
