package com.dtyunxi.yundt.cube.center.account.api.enums;


/**
 * 充值
 *
 * @author sumo on 2020/10/13 0013
 */
public enum RechargeTypeEnum {
 
    /**
     * RechargeTypeEnum - CASH-现金支付,BANK_TRANSFER-银行转账,WE_PAY-微信支付
     */
    CASH("CASH", "现金支付"),
    BANK_TRANSFER("BANK_TRANSFER", "银行转账"),
    WE_PAY("WE_PAY", "微信支付"),

    ;

    private final String code;
    private final String name;

    RechargeTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static RechargeTypeEnum fromCode(String status) {
        for (RechargeTypeEnum typeEnum : RechargeTypeEnum.values()) {
            if (typeEnum.getCode().equals(status)) {
                return typeEnum;
            }
        }
        return null;
    }

    public static String toCode(String status) {
        RechargeTypeEnum importStatusEnum = fromCode(status);
        return importStatusEnum == null ? null : importStatusEnum.getCode();
    }

    public static String toName(String status) {
        RechargeTypeEnum importStatusEnum = fromCode(status);
        return importStatusEnum == null ? null : importStatusEnum.getName();
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
