/*
 * @(#)WithDrawStepEnum.java 1.0 2018-10-30
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.account.api.enums;

/**
 * @des 提现状态枚举
 * @author lengqian
 * @data 2020/02/28
 */
public enum WithdrawalRecordStatusEnum {

    /**
     * 提现状态：1-待提现
     */
    STATUS_WAIT(1, "待提现"),
    /**
     * 提现状态：2-冻结金额
     */
    STATUS_FROZEN(2, "冻结金额"),
    /**
     * 提现状态：3-提现失败
     */
    STATUS_FAIL(3, "提现失败"),
    /**
     * 提现状态：4-提现成功,扣款失败
     */
    STATUS_HALF_SUCCESS(4, "提现成功,扣款失败"),
    /**
     * 提现状态：5-提现成功,扣款成功
     */
    STATUS_SUCCESS(5, "提现成功,扣款成功"),

    ;

    private Integer code;
    private String desc;

    WithdrawalRecordStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }}
