/**
 * @(#)UserExceptionCode.java 1.0 2016-11-10
 * <p>
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.account.api.exception;

/**
 * 描述
 *
 * @author 管春
 * @since 0.6.0
 */
public enum AccountExceptionCode {

    ACC_NOT_EXISTS("0000", "资金账户不存在"),
    ACC_STATUS_NOT_ENABLED("0001", "资金账户不可用"),
    ACC_BALANCE_INSUFFICIENT("0002", "资金账户余额不足"),
    VERIFY_CODE_EXPIRATION("0003", "验证码已过期"),
    VERIFY_CODE_ERROR("0004", "验证码错误"),
    PARAMETER_ERROR("0005", "业务参数异常"),
    ACC_TYPE_NOT_SUPPORT("0006", "资金账户不支持该操作"),
    TRAN_NOT_EXISTS("0007", "交易不存在"),
    VERIFY_CODE_CONFIGURATION("0008", "验证码配置不正确"),
    VERIFY_FLOW_ERROR("0018", "流水生成失败"),

    // 充值订单错误码
    RECHARGE_ORDER_NOT_EXIST("0009", "充值订单不存在"),
    RECHARGE_USER_ID_IS_NULL("0010", "用户id不能为空"),
    RECHARGE_ACCOUNT_ID_IS_NULL("0010", "账户id不能为空"),
    RECHARGE_DEVICE_TYPE_IS_NULL("0011", "终端来源类型不能为空"),
    RECHARGE_PAY_AMOUNT_IS_NULL("0012", "实付金额不能为空"),
    RECHARGE_INSTANCE_ID_IS_NULL("0013", "实例id不能为空"),
    RECHARGE_TENENT_ID_IS_NULL("0014", "租户id不能为空"),
    RECHARGE_CLOSETIME_ILLEGAL("0015", "订单过期时间非法"),
    RECHARGE_ORDER_STATUS_ERROR("0016", "订单状态非法"),
    RECHARGE_ORDER_NO_IS_NULL("0017", "订单编号不能为空"),

    // 微信提现
    FROZEN_AMOUNT_ERROR("0018", "冻结余额异常"),
    WITHDRAW_SUCC_DEDUCT_ERROR("0019", "提现成功,账户扣款失败"),
    WITHDRAW_ERROR("0020", "提现失败，请明天再试"),
    WITHDRAW_AMOUNT_NOT_NULL_ERROR("0021", "提现金额不能为空"),
    WITHDRAW_TYPE_NOT_NULL_ERROR("0022", "提现申请类型不能为空"),
    WITHDRAW_MIN_AMOUNT_ERROR("0023", "最小提现金额为1元"),
    WITHDRAW_MAX_AMOUNT_ERROR("0024", "最大单笔可提现金额为2000元"),
    WITHDRAW_USER_NOT_NULL_ERROR("0025", "提现用户id不能为空"),
    WITHDRAW_WX_OPEN_ID_NOT_NULL_ERROR("0026", "微信openid不能为空"),
    WITHDRAW_ACCOUNT_NOT_EXIST_ERROR("0027", "佣金账户不存在"),
    WITHDRAW_ACCOUNT_NO_MONEY_ERROR("0028", "佣金账户没有可提现金额"),
    WITHDRAW_ACCOUNT_MONEY_LESS_ONE_ERROR("0029", "佣金账户余额不足1元"),
    WITHDRAW_RATHER_ACCOUNT_MONEY_ERROR("0030", "提现金额大于佣金账户可提现余额"),
    WITHDRAW_OVERDULE_TIMES_ERROR("0031", "已超出单天可提现次数"),
    WITHDRAW_ID_NOT_NULL_ERROR("0032", "提现申请单Id不能为空"),
    WITHDRAW_APPLY_ORDER_NOT_EXIST_ERROR("0033", "提现申请单不存在"),
    WITHDRAW_APPLY_STATUS_CHANGED_ERROR("0034", "提现申请单状态已变更"),
    WITHDRAW_CONTEXT_ERROR("0036", "获取转账通道上下文环境错误"),
    WITHDRAW_UN_FROZEN_ERROR("0037", "解冻余额失败!"),
    WITHDRAW_APPLY_ID_NOT_NULL_ERROR("0038", "提现申请id不能为空!"),
    WITHDRAW_APPLY_TYPE_NOT_NULL_ERROR("0039", "提现申请类型不能为空!"),
    WITHDRAW_PAY_FINISH_ERROR("0040", "提现已转账!"),
    USER_MEMBER_NOT_EXIST_ERROR("0041", "用户会员信息不存在"),

    ACC_PWD_CHECK_ERROR("0051", "资金账户密码校验失败"),
    ACC_PWD_INVALID("0052", "密码设置不符合规则"),
    ;

    private final String code;

    private final String msg;

     AccountExceptionCode(String val, String info) {
        this.code = val;
        this.msg = info;

    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;

    }
}
