package com.dtyunxi.yundt.cube.center.account.api.exception;

import java.io.Serializable;

/**
 * @author 风行
 * @since 0.5.0
 */
public class VerifyException extends Exception implements Serializable {
    /**
     * 构造函数
     */
    public VerifyException() {
        super();
    }

    /**
     * 构造函数,指定错误信息
     *
     * @param message 错误信息
     */
    public VerifyException(String message) {
        super(message);
    }

    public VerifyException(String errCode, String errMsg) {
        super(errCode + ":" + errMsg);
        this.errCode = errCode;
        this.errMsg = errMsg;
    }

    /**
     * 错误代码
     */
    private String errCode;
    /**
     * 错误描述
     */
    private String errMsg;

    public String getErrCode() {
        return errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }
}
