package com.dtyunxi.yundt.cube.center.account.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.account.AccountFlowSearchReqDto;
import com.dtyunxi.yundt.cube.center.account.api.dto.response.account.AccountFlowChangeTypeRespDto;
import com.dtyunxi.yundt.cube.center.account.api.dto.response.account.AccountFlowQueryRespDto;
import com.dtyunxi.yundt.cube.center.account.api.dto.response.account.AccountFlowQuerySumRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 账户流水服务
 *
 * @author wu.sheng
 * @date 2020/3/4 11:17
 */
@Api(tags = {"账户中心：账户流水查询服务"})
@FeignClient(contextId = "src-main-com-dtyunxi-yundt-cube-center-account-api-query-IAccountFlowCenterQueryApi", name = "${yundt.cube.center.account.api.name:yundt-cube-center-account}",
        path = "/v1/account/flow",
        url = "${yundt.cube.center.account.api:}")
public interface IAccountFlowCenterQueryApi {


    /**
     * 分页查询账户流水
     *
     * @param filter
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping("/list")
    @ApiOperation(value = "分页查询佣金账户流水列表", notes = "filter=AccountFlowQueryReqDto")
    RestResponse<PageInfo<AccountFlowQueryRespDto>> queryByPage(@RequestParam(value = "filter") String filter,
                                                                @RequestParam("pageNum") Integer pageNum,
                                                                @RequestParam("pageSize") Integer pageSize);

    @GetMapping("/search")
    @ApiOperation(value = "分页查询账户流水列表", notes = "AccountFlowSearchReqDto")
    RestResponse<PageInfo<AccountFlowQueryRespDto>> searchByPage(@Validated AccountFlowSearchReqDto body );

    @GetMapping("/exportSearch")
    @ApiOperation(value = "导出查询账户流水列表", notes = "AccountFlowSearchReqDto")
    RestResponse<String> exportSearch(AccountFlowSearchReqDto body );

    @GetMapping("/sumByChangeType")
    @ApiOperation(value = "统计账户流水交易各类型金额", notes = "AccountFlowSearchReqDto")
    RestResponse<AccountFlowQuerySumRespDto> sumByChangeType(AccountFlowSearchReqDto body );

    @GetMapping("/changeType/list")
    @ApiOperation(value = "查询交易类型列表", notes = "filter=AccountFlowQueryReqDto")
    RestResponse<List<AccountFlowChangeTypeRespDto>> queryChangeTypeList();

}
