/**
 * @(#) IAccountApi.java 1.0 2018-09-17
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.account.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.account.AccountPreReqDto;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.account.QueryAccListReqDto;
import com.dtyunxi.yundt.cube.center.account.api.dto.response.account.AccountPreRespDto;
import com.dtyunxi.yundt.cube.center.account.api.dto.response.account.QueryAccRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author 风行
 * @since 0.5.0
 */
@Api(tags = {"账户中心：资金账户查询服务"})
@FeignClient(contextId="src-main-com-dtyunxi-yundt-cube-center-account-api-query-IAccountQueryApi", name = "${yundt.cube.center.account.api.name:yundt-cube-center-account}", path = "/v2/account", url = "${yundt.cube.center.account.api:}")
public interface IAccountQueryApi {

    /**
     * 查询账户信息
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/{id}")
    @ApiOperation(value = "查询账户信息", notes = "查询账户信息")
    RestResponse<QueryAccRespDto> queryAccount(@NotNull(message = "账户id不能为空") @PathVariable("id") Long id);


    /**
     * 根据会员Id查询账户信息
     *
     * @param memberId
     * @return
     */
    @GetMapping(value = "/member/{memberId}")
    @ApiOperation(value = "根据会员Id查询账户信息", notes = "根据会员Id查询账户信息")
    RestResponse<List<QueryAccRespDto>> queryAccountByMemberId(@NotNull(message = "会员ID不能为空") @PathVariable("memberId") Long memberId,
                                                     @RequestParam(value = "accountType", required = false) String accountType);

    /**
     * 根据用户类型查询默认余额账户信息
     *
     * @param userType : 普通用户：PERSONAL_PLATFORM会员类型：PERSONAL_MEMBER 企业类型： ENTERPRISE
     * @param userId : 不同类型对应的用户id: 企业类型对于的客户id
     * @return
     */
    @GetMapping(value = "/user/{userType}/{userId}")
    @ApiOperation(value = "根据用户类型、用户id 查询账户信息", notes = "根据用户类型和用户id 查询账户信息"+
      "\n 企业类型： ENTERPRISE \n"+
      "\n 个人会员级账户: PERSONAL_MEMBER \n"+
      "\n 个人平台级账户: PERSONAL_PLATFORM \n")
    RestResponse<List<QueryAccRespDto>> queryAccountByUserType(@NotNull(message = "用户类型不能为空") @PathVariable(value = "userType" ) String userType
                                                               ,@NotNull(message = "用户id不能为空")  @PathVariable(value = "userId" ) Long userId
                                                               ,@RequestParam(value = "accountType", required = false,defaultValue="NORMAL") String accountType);

    /**
     * 查询账户列表
     *
     * @param filter
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping(value = "/page")
    @ApiOperation(value = "查询账户列表", notes = "查询账户列表\t\n " +
            "filter:账户列表查询条件封装对象JSON {\n" +
            "    \"nickName\": string,\n" +
            "    \"mobile\": \"string\",\n" +
            "    \"status\": \"string\",\n" +
            "    \"memberNo\": \"string\",\n" +
            "    \"customerNo\": \"string\",\n" +
            "    \"email\": string,\n" +
            "    \"instanceId\": 0,\n" +
            "    \"tenantId\": 0\n" +
            "} \t\n pageNum:指定页码 \t\n pageSize:指定每页返回的对象个数")
    RestResponse<PageInfo<QueryAccRespDto>> queryList(@RequestParam("filter") String filter
            , @RequestParam(name = "pageNum" , required = false, defaultValue = "1") Integer pageNum
            , @RequestParam(name = "pageSize" , required = false, defaultValue = "10") Integer pageSize);


    /***
     * 导出账户查询列表
     * @return
     */
    @GetMapping(value = "/exportAccountList")
    @ApiOperation(value = "客户关键字查询账户列表导出", notes = "客户关键字查询账户列表导出" )
    RestResponse<String> exportAccountQueryList(QueryAccListReqDto reqDto );

    @PostMapping("/search")
    @ApiOperation(value = "客户关键字查询账户列表", notes = "客户关键字查询账户列表 " )
    RestResponse<PageInfo<QueryAccRespDto>> searchAccountList(@RequestBody @Validated QueryAccListReqDto reqDto);


    /**
     * 账号详情预览
     *
     * @param accReqDto
     * @return
     */
    @PostMapping(value = "/pre")
    @ApiOperation(value = "账号详情预览", notes = "账号详情预览")
    RestResponse<AccountPreRespDto> findAccountForCustomer(@RequestBody AccountPreReqDto accReqDto);

    /**
     * 获取密码
     *
     * @param password
     * @return
     */
    @GetMapping(value = "/check/{accountId}/{password}")
    @ApiOperation(value = "验证密码", notes = "验证密码")
    RestResponse<Boolean> checkPassword(@PathVariable(value="accountId") Long accountId,@PathVariable(value="password") String password);

}
