/**
 * @(#) IAccountApi.java 1.0 2018-09-17
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.account.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.account.api.dto.response.account.QueryAccountRechargeOrderRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotNull;

/**
 * @des 充值订单查询服务
 * @author lengqian
 * @data 2019/08/05
 */
@Api(tags = {"账户中心：充值订单查询服务"})
@FeignClient(contextId="src-main-com-dtyunxi-yundt-cube-center-account-api-query-IAccountRechargeOrderQueryApi", name = "${yundt.cube.center.account.api.name:yundt-cube-center-account}", path = "/v2/recharge", url = "${yundt.cube.center.account.api:}")
public interface IAccountRechargeOrderQueryApi {

    /**
     * 根据订单编号查询充值订单详情
     *
     * @param orderNo
     * @return
     */
    @GetMapping(value = "/{orderNo}")
    @ApiOperation(value = "根据订单编号查询充值订单详情", notes = "根据订单编号查询充值订单详情")
    RestResponse<QueryAccountRechargeOrderRespDto> queryRechargeOrderDetail(@NotNull(message = "订单编号不能为空") @PathVariable("orderNo") String orderNo);

    /**
     * 查询充值订单列表
     *
     * @param filter
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping(value = "/page")
    @ApiOperation(value = "查询充值订单列表/充值记录", notes = "查询充值订单列表\t\n " +
            "filter:充值订单列表查询条件封装对象JSON （对应QueryAddAccountRechargeOrderListReqDto对象）{\n" +
            "    \"orderStatus\": STATUS_WAIT_ADU-待审核,WAIT_PAY-待支付,PAYED_SUCC-充值成功,PAYED_FAIL-充值失败,\n" +
            "    \"keyword\": 客户名称/客户编号\n" +
            "    \"rechargeType\": 充值方式,现金支付CASH,银行转账BANK_TRANSFER,微信支付WE_PAY\n" +
            "    \"startDay\": 开始时间\n" +
            "    \"endDay\": 结束时间\n" +
            "    \"startAduDay\": 审核开始时间\n" +
            "    \"endAduDay\": 审核结束时间\n" +
            "    \"isOffline\": 是否仅展示线下充值方式的单子 1是2否\n" +
            "    \"userId\": 用户id,不传默认登录用户\n" +
            "    \"createUser\": 创建人姓名\n" +
            "    \"financialAdu\": 线下单审核状态(线下单审核状态 - WAIT_ADU-待审核,PASS-审核通过,REJECT-已驳回)\n")
    RestResponse<PageInfo<QueryAccountRechargeOrderRespDto>> queryPageList(@SpringQueryMap  String filter
            , @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum
            , @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);



}
