/*
 * @(#)ICardQueryApi.java 1.0 2018-10-29
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.account.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.account.api.dto.response.account.QueryBindCardRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author 风行
 * @since 0.5.0
 */
@Api(tags = {"账户中心：资金账户银行卡查询服务"})
@FeignClient(contextId="src-main-com-dtyunxi-yundt-cube-center-account-api-query-ICardQueryApi", name = "${yundt.cube.center.account.api.name:yundt-cube-center-account}", path = "/v2/card", url = "${yundt.cube.center.account.api:}")
public interface ICardQueryApi {

    /**
     * 查询账户绑卡信息
     *
     * @param accountId
     * @param filter
     * @return
     */
    @GetMapping(value = "/account/{accountId}")
    @ApiOperation(value = "查询账户绑卡信息列表", notes = "查询账户绑卡信息列表")
    RestResponse<List<QueryBindCardRespDto>> queryBindList(@NotNull(message = "账户id不能为空") @PathVariable("accountId") Long accountId, @RequestParam("filter") String filter);

    /**
     * 查询绑卡明细信息
     *
     * @param id
     * @param filter
     * @return
     */
    @GetMapping(value = "/{id}")
    @ApiOperation(value = "查询绑卡明细信息", notes = "查询绑卡明细信息")
    RestResponse<QueryBindCardRespDto> queryBindCard(@NotNull(message = "绑卡id不能为空") @PathVariable("id") Long id, @RequestParam("filter") String filter);

}
