package com.dtyunxi.yundt.cube.center.account.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.account.ExportBaseReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;

/**
 * 账户中心：基础通用api
 */
@Api(tags = {"账户中心：基础通用api"})
@FeignClient(contextId = "src-main-com-dtyunxi-yundt-cube-center-account-api-query-ICommonQueryApi", name = "${yundt.cube.center.account.api.name:yundt-cube-center-account}",
        path = "/v1/common",
        url = "${yundt.cube.center.account.api:}")
public interface ICommonQueryApi {


    @GetMapping("/export")
    @ApiOperation(value = "导出", notes = "基础导出,导出类型 账号流水-ACCOUNT_FLOW;充值记录-RECHARGE_RECORD;充值单-RECHARGE_ORDER")
    RestResponse<String> exportSearch(@SpringQueryMap ExportBaseReqDto exportBaseReqDto);
}

