package com.dtyunxi.yundt.cube.center.account.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.account.api.dto.response.PayeeConfigRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;


/**
 * 收款方配置
 * @author sumo
 */
@Api(tags = {"收款配置"})
@FeignClient(contextId="src-main-com-dtyunxi-yundt-cube-biz-account-api-query-IPayeeConfigQueryApi",
        name = "${yundt.cube.center.account.api.name:yundt-cube-center-account}",
        path = "/v1/Payee-config", url = "${yundt.cube.center.account.api:}")
public interface IPayeeConfigQueryApi {


    /**
     * 查询平台或经销商收款配置详情
     *
     * @param
     * @return 查询收款配置详情
     */
    @GetMapping("/query/config")
    @ApiOperation(value = "查询平台或经销商收款配置详情", notes = "不传payeeId默认查询总平台配置")
    RestResponse<PayeeConfigRespDto> queryPayeeConfigDetailByPayeeId(@RequestParam(value = "payeeId",required = false) Long payeeId);


}
