/**
 * @(#) ITransactionApi.java 1.0 2018-09-17
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.account.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.account.api.dto.response.tran.QueryAccTranDetailRespDto;
import com.dtyunxi.yundt.cube.center.account.api.dto.response.tran.QueryAccTranHistoryRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author 风行
 * @since 0.5.0
 */
@Api(tags = {"账户中心：资金账户交易记录查询服务"})
@FeignClient(contextId="src-main-com-dtyunxi-yundt-cube-center-account-api-query-ITransactionQueryApi", name = "${yundt.cube.center.account.api.name:yundt-cube-center-account}", path = "/v2/transaction", url = "${yundt.cube.center.account.api:}")
public interface ITransactionQueryApi {

    /**
     * 查询交易记录
     *
     * @param filter
     * @return
     */
    @GetMapping(value = "/page")
    @ApiOperation(value = "查询账户交易记录列表", notes = "查询账户交易记录列表\t\n " +
            "filter:账户交易记录列表查询条件封装对象JSON {\n" +
            "    \"accountId\": long,\n" +
            "    \"tranType\": \"string\",\n" +
            "    \"instanceId\": 0,\n" +
            "    \"tenantId\": 0\n" +
            "} \t\n pageNum:指定页码 \t\n pageSize:指定每页返回的对象个数")
    RestResponse<PageInfo<QueryAccTranHistoryRespDto>> queryTranHistory(@RequestParam("filter") String filter
            , @RequestParam(name = "pageNum" , required = false, defaultValue = "1") Integer pageNum
            , @RequestParam(name = "pageSize" , required = false, defaultValue = "10") Integer pageSize);


    /**
     * 查询交易明细
     *
     * @param filter
     * @return
     */
    @GetMapping(value = "/{id}")
    @ApiOperation(value = "查询交易明细", notes = "查询交易明细\t\n " +
            "filter:交易明细查询条件封装对象JSON {\n" +
            "    \"instanceId\": 0,\n" +
            "    \"tenantId\": 0\n" +
            "}")
    RestResponse<QueryAccTranDetailRespDto> queryTranDetail(@PathVariable("id") Long id, @RequestParam("filter") String filter);

    /**
     * 查询交易明细
     *
     * @param filter
     * @return
     */
    @GetMapping("")
    @ApiOperation(value = "查询交易明细", notes = "查询交易明细\t\n " +
            "filter:交易明细查询条件封装对象JSON {\n" +
            "    \"id\": long,\n" +
            "    \"instanceId\": 0,\n" +
            "    \"tenantId\": 0\n" +
            "}")
    RestResponse<QueryAccTranDetailRespDto> queryTranDetail(@RequestParam("filter") String filter);
}
