/**
 * @(#)IWithdrawApplyRecordQueryApi.java 1.0 2020/3/5
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.account.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.account.api.dto.response.withdraw.WithdrawApplyRecordRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author 伊泽
 * @since 1.0.0
 */
@Api(tags = {"账户中心：提现申请查询服务"})
@FeignClient(contextId = "src-main-com-dtyunxi-yundt-cube-center-account-api-query-IWithdrawApplyRecordQueryApi", name = "${yundt.cube.center.account.api.name:yundt-cube-center-account}", path = "/v2/withdraw/apply", url = "${yundt.cube.center.account.api:}")
public interface IWithdrawApplyRecordQueryApi {

    /**
     * 分页查询提现申请单列表
     *
     * @param filter   查询条件，json字符串
     * @param pageNum  分页页码
     * @param pageSize 分页行数
     * @return WithdrawApplyRecordRespDto 分页提现申请单Dto分页列表
     */
    @GetMapping(value = "/list", produces = "application/json")
    @ApiOperation(value = "分页查询提现申请单列表", notes = "分页查询结算单列表，filter = WithdrawApplyRecordReqDto")
    RestResponse<PageInfo<WithdrawApplyRecordRespDto>> queryByPage(@RequestParam(name = "filter") String filter, @RequestParam(name = "pageNum") Integer pageNum, @RequestParam(name = "pageSize") Integer pageSize);


}
