/**
 * @(#) IAccountApi.java 1.0 2018-09-17
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.account.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.withdraw.WithdrawRuleQueryReqDto;
import com.dtyunxi.yundt.cube.center.account.api.dto.response.withdraw.WithdrawRuleRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;

/**
 * 提现查询
 */
@Api(tags = {"账户中心：提现查询"})
@FeignClient(contextId = "src-main-com-dtyunxi-yundt-cube-center-account-api-IWithdrawQueryApi", name = "${yundt.cube.center.account.api.name:yundt-cube-center-account}", path = "/v2/withdraw", url = "${yundt.cube.center.account.api:}")
public interface IWithdrawQueryApi {

    /**
     * 查询提现规则
     *
     * @param withdrawRuleQueryReqDto
     * @return
     */
    @GetMapping(value = "/rule")
    @ApiOperation(value = "根据Id查询提现规则", notes = "根据Id查询提现规则")
    RestResponse<WithdrawRuleRespDto> queryRule(@ModelAttribute WithdrawRuleQueryReqDto withdrawRuleQueryReqDto);

}
