package com.dtyunxi.yundt.cube.center.account.api.util;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
/**
 * @des 时间工具类
 * @author lengqian
 * @data 2020/03/05
 */
public class DateTimeUtils {
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final String COMPACT_DATE_PATTERN = "yyyyMMdd";
    private static final String COMPACT_TIME_PATTERN = "HHmmss";
    private static final String MM_TIME_PATTERN = "HH:mm";
    private static final String HOURS_TIME_PATTERN = "HH";
    private static final String MM_TIME_PATTERN_CHINA = "HH分mm秒";
    private static final String C_MM_TIME_PATTERN = "ahh:mm";   //下午01:40
    private static final String TIME_PATTERN = "HH:mm:ss";
    private static final String MIL_PATTERN = "HH:mm:ss:SSS";
    private static final String TIME_PATTERN_WEEK = "yyyy-MM-dd E";
    private static final String DATE_PATTERN_CN = "yyyy年MM月dd日";
    private static final String MONTH_DAY_CN = "MM月dd日";
    private static final String DATE_TIME_ALL = "yyyy.MM.dd HH:mm:ss";
    private static final String DATE_DAY = "dd日";
    private static final String MOUTH_DATE_PATTERN = "yyyy-MM";
    /* ------------------------------  类型转换方法 --------------------------- */

    private static String[] parsePatterns = {"yyyy-MM-dd", "yyyy年MM月dd日",
            "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy/MM/dd",
            "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyyMMdd"};


    /**
     * 判断字符串是不是指定时间日期格式
     *
     * @param string 字符串
     * @param fromat 指定格式,null则默认为全部格式
     * @return
     */
    public static Date parseDate(String string, String fromat) {
        if (string == null) {
            return null;
        }
        String[] pointPattern;
        if (StringUtils.isBlank(fromat)) {
            pointPattern = new String[]{fromat};
        } else {
            pointPattern = parsePatterns;
        }

        try {
            return DateUtils.parseDate(string, pointPattern);
        } catch (ParseException e) {
            return null;
        }
    }

    /**
     * 判断字符串是不是时间日期格式
     * Created by sumo on 2021/5/28
     */
    public static Date parseDate(String string) {
        return parseDate(string, null);
    }

    public static final String convertDateToWeekString(Date aDate) {
        return aDate == null ? null : (new SimpleDateFormat(TIME_PATTERN_WEEK)).format(aDate);
    }

    public static final String convertDateToString(Date aDate, String pattern) {
        return aDate == null ? null : (new SimpleDateFormat(pattern)).format(aDate);
    }

    public static final String convertDateToString(Date aDate) {
        return aDate == null ? null : (new SimpleDateFormat(DATE_PATTERN)).format(aDate);
    }

    public static final String convertDateToCnString(Date aDate) {
        return aDate == null ? null : (new SimpleDateFormat(DATE_PATTERN_CN)).format(aDate);
    }

    public static final Date convertCnStringToDate(String cnString) throws ParseException {
        return StringUtils.isBlank(cnString) ? null : (new SimpleDateFormat(DATE_PATTERN_CN)).parse(cnString);
    }

    public static final String convertDateToAllString(Date aDate) {
        return aDate == null ? null : (new SimpleDateFormat(DATE_TIME_ALL)).format(aDate);
    }

    public static Date convertStringToDate(String strDate) throws ParseException {
        return StringUtils.isBlank(strDate) ? null : (new SimpleDateFormat(DATE_PATTERN)).parse(strDate);
    }

    public static final String convertDateToCompactString(Date aDate) {
        return aDate == null ? null : (new SimpleDateFormat(COMPACT_DATE_PATTERN)).format(aDate);
    }

    public static Date convertCompactStringToDate(String strDate) throws ParseException {
        return (new SimpleDateFormat(COMPACT_DATE_PATTERN)).parse(strDate);
    }

    public static final String convertTimeToCompactString(Date aDate) {
        return aDate == null ? null : (new SimpleDateFormat(COMPACT_DATE_PATTERN + COMPACT_TIME_PATTERN)).format(aDate);
    }
    public static final String convertTimeToMandDay(Date aDate) {
        return aDate == null ? null : (new SimpleDateFormat(MONTH_DAY_CN +" "+ MM_TIME_PATTERN)).format(aDate);
    }

    public static Date convertCompactStringToTime(String strDate) throws ParseException {
        return (new SimpleDateFormat(COMPACT_DATE_PATTERN + COMPACT_TIME_PATTERN)).parse(strDate);
    }

    public static java.sql.Date convertStringToSqlDate(String strDate) throws ParseException {
        return new java.sql.Date((new SimpleDateFormat(DATE_PATTERN)).parse(strDate).getTime());
    }

    public static final String convertMmTimeToString(Date aTime) {
        return aTime == null ? null : (new SimpleDateFormat(MM_TIME_PATTERN)).format(aTime);
    }

    public static final String convertMmTimeToChinaString(Date aTime) {
        return aTime == null ? null : (new SimpleDateFormat(MM_TIME_PATTERN_CHINA)).format(aTime);
    }

    public static final String convertCMmTimeToString(Date aTime) {
        return aTime == null ? null : (new SimpleDateFormat(C_MM_TIME_PATTERN)).format(aTime);
    }

    public static Date convertStringToMmTime(String strMmTime) throws ParseException {
        return StringUtils.isBlank(strMmTime) ? null : new Date((new SimpleDateFormat(MM_TIME_PATTERN)).parse(strMmTime).getTime());
    }

    public static Date convertStringToCMmTime(String strMmTime) throws ParseException {
        return new Date((new SimpleDateFormat(DATE_PATTERN + " " + C_MM_TIME_PATTERN)).parse(strMmTime).getTime());
    }

    public static final String convertDateTimeToString(Date aDateTime) {
        return aDateTime == null ? null : (new SimpleDateFormat(DATE_PATTERN + " " + TIME_PATTERN)).format(aDateTime);
    }

    public static final String convertDateTimeToMilString(Date aDateTime) {
        return aDateTime == null ? null : (new SimpleDateFormat(DATE_PATTERN + " " + MIL_PATTERN)).format(aDateTime);
    }

    public static final String convertDateTimeToMmString(Date aDateTime) {
        return aDateTime == null ? null : (new SimpleDateFormat(DATE_PATTERN + " " + MM_TIME_PATTERN)).format(aDateTime);
    }

    public static final String convertDateTimeToHoursString(Date aDateTime) {
        return aDateTime == null ? null : (new SimpleDateFormat(DATE_PATTERN + " " + HOURS_TIME_PATTERN)).format(aDateTime);
    }

    public static final Date convertMmStringToDateTime(String strMmDateTime) throws ParseException {
        return StringUtils.isBlank(strMmDateTime) ? null : new Date((new SimpleDateFormat(DATE_PATTERN + " " + MM_TIME_PATTERN)).parse(strMmDateTime).getTime());
    }

    public static Date convertStringToDateTime(String strDateTime) throws ParseException {
        return StringUtils.isBlank(strDateTime) ? null : new Date((new SimpleDateFormat(DATE_PATTERN + " " + TIME_PATTERN)).parse(strDateTime).getTime());
    }

    public static Date convertStringToDateTime(String datePattern, String strDateTime) {
        try {
            return new Date((new SimpleDateFormat(datePattern)).parse(strDateTime).getTime());
        } catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /* -----------------------------  以下是日期运算方法 --------------------------- */

    public static Date getMonthEndTime(Calendar calendar) {
        Calendar tmpCalendar = (Calendar) calendar.clone();
        tmpCalendar.set(Calendar.DAY_OF_MONTH, 1);
        tmpCalendar.set(Calendar.HOUR_OF_DAY, 0);
        tmpCalendar.set(Calendar.MINUTE, 0);
        tmpCalendar.set(Calendar.SECOND, 0);
        tmpCalendar.set(Calendar.MILLISECOND, 0);

        tmpCalendar.add(Calendar.MONTH, 1);
        tmpCalendar.add(Calendar.MILLISECOND, -1);
        //毫秒统一设置为0，避免因为毫秒导致进位
        tmpCalendar.set(Calendar.MILLISECOND, 0);
        return tmpCalendar.getTime();
    }

    public static Date getMonthEndTime(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.YEAR, year);
        calendar.set(Calendar.MONTH, month - 1);
        return getMonthEndTime(calendar);
    }

    public static Date getMonthEndTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return getMonthEndTime(calendar);
    }

    public static Date getMonthStartTime(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.YEAR, year);
        calendar.set(Calendar.MONTH, month - 1);
        return getMonthStartTime(calendar);
    }

    public static Date getMonthStartTime(Calendar calendar) {
        Calendar tmpCalendar = (Calendar) calendar.clone();
        tmpCalendar.set(Calendar.DAY_OF_MONTH, 1);
        tmpCalendar.set(Calendar.HOUR_OF_DAY, 0);
        tmpCalendar.set(Calendar.MINUTE, 0);
        tmpCalendar.set(Calendar.SECOND, 0);
        tmpCalendar.set(Calendar.MILLISECOND, 0);
        return tmpCalendar.getTime();
    }

    public static Date getMonthStartTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return getMonthStartTime(calendar);
    }

    public static Date getDayEndTime(Calendar calendar) {
        Calendar tmpCalendar = (Calendar) calendar.clone();
        tmpCalendar.set(Calendar.HOUR_OF_DAY, 0);
        tmpCalendar.set(Calendar.MINUTE, 0);
        tmpCalendar.set(Calendar.SECOND, 0);
        tmpCalendar.set(Calendar.MILLISECOND, 0);

        tmpCalendar.add(Calendar.DATE, 1);
        tmpCalendar.add(Calendar.MILLISECOND, -1);
        //毫秒统一设置为0，避免因为毫秒导致进位
        tmpCalendar.set(Calendar.MILLISECOND, 0);
        return tmpCalendar.getTime();
    }

    public static Date getDayEndTime(int year, int month, int day) {

        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.YEAR, year);
        calendar.set(Calendar.MONTH, month - 1);
        calendar.set(Calendar.DAY_OF_MONTH, day);
        return getDayEndTime(calendar);
    }

    public static Date getDayEndTime(Date date) {
        if(date==null){
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return getDayEndTime(calendar);
    }

    public static Date getDayEndTimeIfTimeNull(String date) {
        if (StringUtils.isBlank(date)) {
            return null;
        }
        Date date_pattern = parseDate(date, DATE_PATTERN);
        //如果格式为 "yyyy-MM-dd"
        if (date_pattern != null) {
            return parseDate(date);
        }

        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateTimeUtils.convertStringToDateTime(DATE_PATTERN, date));
        return getDayEndTime(calendar);
    }

    public static Date getDayEndTime(String date) {
        if (StringUtils.isBlank(date)) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateTimeUtils.convertStringToDateTime(DATE_PATTERN, date));
        return getDayEndTime(calendar);
    }

    public static Date getDayStartTime(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.YEAR, year);
        calendar.set(Calendar.MONTH, month - 1);
        calendar.set(Calendar.DAY_OF_MONTH, day);
        return getDayStartTime(calendar);
    }

    public static Date getDayStartTime(Calendar calendar) {
        Calendar tmpCalendar = (Calendar) calendar.clone();
        tmpCalendar.set(Calendar.HOUR_OF_DAY, 0);
        tmpCalendar.set(Calendar.MINUTE, 0);
        tmpCalendar.set(Calendar.SECOND, 0);
        tmpCalendar.set(Calendar.MILLISECOND, 0);
        return tmpCalendar.getTime();
    }

    public static Date getDayStartTime(Date date) {
        if(date==null){
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return getDayStartTime(calendar);
    }

    public static Date getDayStartTime(String date) {
        if (StringUtils.isBlank(date)) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateTimeUtils.convertStringToDateTime(DATE_PATTERN, date));
        return getDayStartTime(calendar);
    }

    public static Date getWeekStartTime(Calendar calendar) {
        Calendar tmpCalendar = (Calendar) calendar.clone();
        tmpCalendar.set(Calendar.HOUR_OF_DAY, 0);
        tmpCalendar.set(Calendar.MINUTE, 0);
        tmpCalendar.set(Calendar.SECOND, 0);
        tmpCalendar.set(Calendar.MILLISECOND, 0);
        tmpCalendar.setFirstDayOfWeek(Calendar.MONDAY);
        tmpCalendar.set(Calendar.DAY_OF_WEEK, tmpCalendar.getFirstDayOfWeek());
        return tmpCalendar.getTime();
    }

    public static Date getWeekStartTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return getWeekStartTime(calendar);
    }

    public static Date getWeekEndTime(Calendar calendar) {
        Calendar tmpCalendar = (Calendar) calendar.clone();
        tmpCalendar.set(Calendar.HOUR_OF_DAY, 0);
        tmpCalendar.set(Calendar.MINUTE, 0);
        tmpCalendar.set(Calendar.SECOND, 0);
        tmpCalendar.set(Calendar.MILLISECOND, 0);
        tmpCalendar.setFirstDayOfWeek(Calendar.MONDAY);
        tmpCalendar.set(Calendar.DAY_OF_WEEK, tmpCalendar.getFirstDayOfWeek());
        tmpCalendar.add(Calendar.DATE, 7);
        tmpCalendar.set(Calendar.MILLISECOND, -1);
        //毫秒统一设置为0，避免因为毫秒导致进位
        tmpCalendar.set(Calendar.MILLISECOND, 0);
        return tmpCalendar.getTime();
    }

    public static Date getWeekEndTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return getWeekEndTime(calendar);
    }

    public static String getDayOfWeekStr(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String str = "";
        switch (calendar.get(Calendar.DAY_OF_WEEK)) {
            case 1:
                str = "星期日";
                break;
            case 2:
                str = "星期一";
                break;
            case 3:
                str = "星期二";
                break;
            case 4:
                str = "星期三";
                break;
            case 5:
                str = "星期四";
                break;
            case 6:
                str = "星期五";
                break;
            case 7:
                str = "星期六";
                break;
            default:
                break;
        }
        return str;
    }

    public static String getDayOfWeekStrExt(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String str = "";
        switch (calendar.get(Calendar.DAY_OF_WEEK)) {
            case 1:
                str = "周日";
                break;
            case 2:
                str = "周一";
                break;
            case 3:
                str = "周二";
                break;
            case 4:
                str = "周三";
                break;
            case 5:
                str = "周四";
                break;
            case 6:
                str = "周五";
                break;
            case 7:
                str = "周六";
                break;
            default:
                break;
        }
        return str;
    }

    public static int getHourOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(Calendar.HOUR_OF_DAY);
    }

    public static int getMinuteOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(Calendar.MINUTE);
    }

    public static int getYearOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(Calendar.YEAR);
    }


    //---------------------------------------------------------

    public static Date getCurentWeekStartTime() {
        return getWeekStartTime(new Date());
    }

    public static Date getCurentWeekEndTime() {
        return getWeekEndTime(new Date());
    }

    public static Date getCurentMonthStartTime() {
        return getMonthStartTime(new Date());
    }

    public static Date getCurentMonthEndTime() {
        return getMonthEndTime(new Date());
    }


    public static String getTimeString(Long millisecond) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(millisecond);
        return (new SimpleDateFormat(DATE_PATTERN + " " + TIME_PATTERN)).format(calendar.getTime());
    }

    /**
     * 2018-1-1 00:00:00 - 2017-12-31 11:59:59 = 1
     * date2比date1大的天数
     */
    public static int betweenDays(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        int day1 = cal1.get(Calendar.DAY_OF_YEAR);
        int day2 = cal2.get(Calendar.DAY_OF_YEAR);
        int year1 = cal1.get(Calendar.YEAR);
        int year2 = cal2.get(Calendar.YEAR);
        if (year1 != year2) {
            int timeDistance = 0;
            for (int i = year1; i < year2; i++) {
                if (i % 4 == 0 && i % 100 != 0 || i % 400 == 0) {// 闰年
                    timeDistance += 366;
                } else {// 不是闰年
                    timeDistance += 365;
                }
            }
            return timeDistance + (day2 - day1);
        } else {
            return day2 - day1;
        }
    }


    /**
     * 计算两个日期相差的月份数
     *
     * @param date1 日期1
     * @param date2 日期2
     * @return 相差的月份数
     */
    public static Integer betweenMonths(Date date1, Date date2) {

        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(date1);
        c2.setTime(date2);

        int year = c2.get(Calendar.YEAR) - c1.get(Calendar.YEAR);

        //开始日期若小月结束日期
        if (year < 0) {
            year = -year;
            return year * 12 + c1.get(Calendar.MONTH) - c2.get(Calendar.MONTH);
        }

        return year * 12 + c2.get(Calendar.MONTH) - c1.get(Calendar.MONTH);
    }

    /**
     * 增减天数(+1:明天.-1:昨天)
     */
    public static Date addDay(Date date, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.DAY_OF_MONTH, day);
        return calendar.getTime();
    }

    /**
     * 增减年数(+1:明年.-1:去天)
     */
    public static Date addYear(Date date, int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.YEAR, year);
        return calendar.getTime();
    }

    /**
     * 添加/减少分钟
     */
    public static Date addAndSubMin(Date date, int min) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.MINUTE, min);
        return calendar.getTime();
    }

    /**
     * 计算两个日期相差年数
     */
    public static Integer betweenYears(Date startDate, Date endDate) {
        Calendar startCalendar = Calendar.getInstance();
        Calendar endCalendar = Calendar.getInstance();
        startCalendar.setTime(startDate);
        endCalendar.setTime(endDate);
        return endCalendar.get(Calendar.YEAR) - startCalendar.get(Calendar.YEAR);
    }

    /**
     * 计算会员年龄 统一使用此方法
     */
    public static Integer calculateAge(Date birthday) {
        Integer age = birthday == null ? 0 : DateTimeUtils.betweenYears(birthday, new Date());
        return age == 0 ? 1 : age;
    }


    /**
     * 两个日期之间相差秒数
     * 结束- 开始
     *
     * @param startDate
     * @param endDate
     * @return
     */
    public static int getDateDifference(Date startDate, Date endDate) {
        return getMillisecondDifference(startDate, endDate) / 1000;
    }

    /**
     * 两个日期之间相差毫秒数
     * 结束- 开始
     *
     * @param startDate
     * @param endDate
     * @return
     */
    public static int getMillisecondDifference(Date startDate, Date endDate) {
        long a = startDate.getTime();
        long b = endDate.getTime();
        return (int) (b - a);
    }

    /**
     * 得到本周周一
     * day 周几
     * 1 周一
     * 2 周二
     *
     * @return yyyy-MM-dd
     */
    public static Date getPointDayOfThisWeek(Date data, int day) {
        Calendar c = Calendar.getInstance();
        c.setTime(data);
        int dayofweek = c.get(Calendar.DAY_OF_WEEK) - 1;
        if (dayofweek == 0) {
            dayofweek = 7;
        }

        c.add(Calendar.DATE, -dayofweek + day);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return c.getTime();
    }


    /**
     * 把两个毫秒数差值传进来就可以看见相差多久
     *
     * @param mss
     * @return
     */
    public static String formatDuring(long mss) {
        long days = mss / (1000 * 60 * 60 * 24);
        long hours = (mss % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60);
        long minutes = (mss % (1000 * 60 * 60)) / (1000 * 60);
        long seconds = (mss % (1000 * 60)) / 1000;
        return (days > 0 ? (days + "天") : "") + (hours > 0 ? (hours + "时") : "") + (minutes > 0 ? (minutes + "分") : "")
                + (seconds > 0 ? seconds + "秒 " : "");
    }

    /**
     * 获取当年年份
     *
     * @return
     */
    public static String getCurrentYear() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        Date date = new Date();
        return sdf.format(date);
    }

    /**
     * @param date 要判断是否在当天24h内的时间
     * @return 是否为当天24h内
     * boolean
     * @Description
     */
    public static boolean isToday(Date date) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(date);
        int year1 = c1.get(Calendar.YEAR);
        int month1 = c1.get(Calendar.MONTH) + 1;
        int day1 = c1.get(Calendar.DAY_OF_MONTH);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(new Date());
        int year2 = c2.get(Calendar.YEAR);
        int month2 = c2.get(Calendar.MONTH) + 1;
        int day2 = c2.get(Calendar.DAY_OF_MONTH);
        if (year1 == year2 && month1 == month2 && day1 == day2) {
            return true;
        }
        return false;
    }

    /**
     * 获取指定月份第一天Date
     *
     * @param dateStr yyyy-MM
     * @return Date类型时间
     */
    public static Date getFirstDayByMonth(String dateStr) throws Exception {
        dateStr = dateStr + "-01";
        return convertStringToDate(dateStr);
    }

    /**
     * 获取指定月份下个月第一天Date
     * @param dateStr
     * @return
     */
    public static Date getNextFirstDayByMonth(String dateStr) throws Exception {
        Date date = getFirstDayByMonth(dateStr);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.MONTH, 1);
        return calendar.getTime();
    }

    /**
     * 得到当天字符串 格式（dd）
     */
    public static final String getDayString(Date aDate) {
        return aDate == null ? null : (new SimpleDateFormat(DATE_DAY)).format(aDate);
    }


    /**
     * 获取 当前时间加多少秒后的 时间
     *
     * @param second 多少秒
     */
    public static Object getHowSecondAfterTime(Integer second, boolean isDateGormat) throws Exception {
        long currentTime = System.currentTimeMillis() + second * 1000;
        Date date = new Date(currentTime);
        if (isDateGormat) {
            return date;
        } else {
            return DateTimeUtils.convertDateTimeToString(date);
        }
    }

    /**
     * 获取某个月的开始时间
     * 示例1：
     * date = 2019-08-02 15:59:30  num = 1
     * 返回的时间： 2019-09-01 00:00:00
     * 示例2：
     * date = 2019-08-02 15:59:30  num = 0
     * 返回的时间： 2018-08-01 00:00:00
     * 示例3：
     * date = 2019-08-02 15:59:30  num = -1
     * 返回的时间： 2019-07-01 00:00:00
     *
     * @param date 对比的时间
     * @param num  前几个月（下个月为 1,上个月为-1，本月为0）
     * @return 某个月的第一天的开始时间
     */
    public static Date getBeforeMonthStartTime(Date date, int num) {
        Date dayStartTime = getDayStartTime(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dayStartTime);
        calendar.add(Calendar.MONTH, num);
        calendar.set(Calendar.DAY_OF_MONTH, 1);
        return calendar.getTime();
    }

    /**
     * 获取某个月的结束时间
     * 示例1：
     * date = 2019-08-02 15:59:30  num = 0
     * 返回的时间： 2019-07-31 59:59:59
     * 示例2：
     * date = 2019-08-02 15:59:30  num = 1
     * 返回的时间： 2019-08-31 59:59:59
     * 示例3：
     * date = 2019-08-02 15:59:30  num = 2
     * 返回的时间： 2019-09-31 59:59:59
     *
     * @param date 对比的时间
     * @param num  前几个月（下个月为 2,上个月为0，本月为1），
     * @return 某个月的最后一天的结束时间
     */
    public static Date getBeforeMonthEndTime(Date date, int num) {
        Date dayEndTime = getDayEndTime(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dayEndTime);
        calendar.add(Calendar.MONTH, num);
        calendar.set(Calendar.DAY_OF_MONTH, 0);
        return calendar.getTime();
    }


    /**
     * 获取传入日期所在年的第一天
     */
    public static Date getFirstDayDateOfYear(Date date) {
        final Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        final int last = cal.getActualMinimum(Calendar.DAY_OF_YEAR);
        cal.set(Calendar.DAY_OF_YEAR, last);
        return cal.getTime();
    }

    /**
     * 获取传入日期所在年的最后一天
     */
    public static Date getLastDayOfYear(final Date date) {
        final Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        final int last = cal.getActualMaximum(Calendar.DAY_OF_YEAR);
        cal.set(Calendar.DAY_OF_YEAR, last);
        return cal.getTime();
    }

    /**
     * 检查是否有效
     */
    public static boolean checkIsEffect(Date startDay, Date endDay) {
        Date date = new Date();
        if (startDay.before(date) && endDay.after(date)) {
            return true;
        }
        return false;
    }


    /**
     * @return boolean
     * @throws
     * @author qisw
     * @date 2019-11-19 17:24
     * @desc 通过传入的时间字符 获取变化之后的时间date类型（这个方法接受的时间字符串格式为  "yyyy-MM--dd" ）注意格式问题
     * value > 0 表示增加 value < 0表示减少
     * key=1 表示操作 年 对应的是Calendar.Calendar.YEAR
     * key=2 表示操作 月 对应的是Calendar.MONTH
     * key=2 表示操作 月 对应的是Calendar.WEEK_OF_YEAR
     * 后期如果有新的需求 key的对应关系可以增加，可以参考Calendar类  ----qisw
     */
    public static Date getChangeDate(Date date, int key, int value) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(key, value);
        return calendar.getTime();

    }

    /**
     * 关于获取当前时间戳的方法
     *
     * @return
     * @throws
     * @author qisw
     * @date 2019-12-05 11:01
     * @desc 获取当前时间的时间戳
     */
    public static String getCurrentDateTime() {
        Long time = System.currentTimeMillis() / 1000L;
        String timestamp = String.valueOf(time);
        return timestamp;
    }

    /**
     * @return
     * @throws
     * @author qisw
     * @date 2019-11-29 16:14
     * @desc 通过与当前时间操作   获取变化之后的时间date类型
     * *       value > 0 表示增加 value < 0表示减少
     * *       key=1 表示操作 年 对应的是Calendar.Calendar.YEAR
     * *       key=2 表示操作 月 对应的是Calendar.MONTH
     * *       后期如果有新的需求 key的对应关系可以增加，可以参考Calendar类  ----qisw
     */
    public static String getNowChangeStr(int key, int value) {
        Calendar calendar = Calendar.getInstance();
        Date date = new Date();
        calendar.setTime(date);
        calendar.add(key, value);
        Date changeDate = calendar.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatter.format(changeDate);
        return dateString;
    }
    /**
     * 获取当天零晨时间
     * @return
     */
    public static Date getStartDayTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.clear(Calendar.MILLISECOND);
        return calendar.getTime();
    }

    /**
     * 获取当天最后时间
     * @return
     */
    public static Date getEndDayTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.HOUR_OF_DAY, 23);
        calendar.set(Calendar.MINUTE, 59);
        calendar.set(Calendar.SECOND, 59);
        calendar.clear(Calendar.MILLISECOND);
        return calendar.getTime();
    }

}
