package com.dtyunxi.yundt.cube.center.account.api.util;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author 风行
 * @since 0.5.0
 */
public class SignUtil {

    private static Logger logger = LoggerFactory.getLogger(SignUtil.class);

    public static String MD5(Map<String, String> encryptMap, String salt) throws Exception {
        List<String> array = new ArrayList<>();
        for (Map.Entry entry : encryptMap.entrySet()) {
            array.add(entry.getKey() + "=" + entry.getValue());
        }
        String encryptSrc = StringUtils.join(array, "&");
        return MD5(encryptSrc + salt);
    }

    public static String getOrgSignData(Map<String, Object> encryptMap){
        List<String> array = new ArrayList<>();
        for (Map.Entry entry : encryptMap.entrySet()) {
            if(entry.getValue()!=null) {
                array.add(entry.getKey() + "=" + entry.getValue());
            }
        }
        return StringUtils.join(array, "&");
    }

    public static String MD5(String s, String charset) throws Exception {
        logger.info("待签字符串为：" + s);
        char[] hexDigits = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        byte[] btInput = s.getBytes(charset);
        MessageDigest mdInst = MessageDigest.getInstance("MD5");
        mdInst.update(btInput);
        byte[] md = mdInst.digest();
        int j = md.length;
        char[] str = new char[j * 2];
        int k = 0;
        for (int i = 0; i < j; i++) {
            byte byte0 = md[i];
            str[k++] = hexDigits[byte0 >>> 4 & 0xf];
            str[k++] = hexDigits[byte0 & 0xf];
        }
        return new String(str);
    }

    public static String MD5(String s) throws Exception {
        return MD5(s, "UTF-8");
    }
}
