package com.dtyunxi.yundt.cube.center.item.api.base;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.AuditResultRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ChangeApplyAuditReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemChangeApplyReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Api(tags = {"商品中心：变更服务"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        contextId = "com-dtyunxi-yundt-cube-center-item-api-b2b-IItemChangeApplyApi",
        path = "/v1/item/apply",
        url = "${yundt.cube.center.item.api:}")
public interface IItemChangeApplyApi {


    /**
     * 新增商品变更记录
     *
     * @param itemChangeApplyReqDto 变更申请信息
     * @return 返回long 添加的变更申请的id
     */
    @PostMapping(value = "")
    @ApiOperation(value = "新增商品变更记录", notes = "新增商品变更记录,返回变更申请的id")
    RestResponse<Long> add( @RequestBody ItemChangeApplyReqDto itemChangeApplyReqDto);

    /**
     * 提交按钮
     *
     * @param id 申请的id，现在仅仅是改个申请状态
     * @return 返回long
     */
    @PutMapping(value = "/{id}/commit")
    @ApiOperation(value = "提交申请", notes = "提交申请，现在仅仅是改个申请状态")
    RestResponse<Void> commit(@Validated @PathVariable("id") Long id);

    /**
     * 审核商品
     *
     * @param changeApplyAuditReqDto 变更申请审核信息
     * @return 商品审核ID 暂定
     */
    @PostMapping(value = "/apply/audit")
    @ApiOperation(value = "审核", notes = "审核")
    RestResponse<AuditResultRespDto> audit(@RequestBody ChangeApplyAuditReqDto changeApplyAuditReqDto);


    /**
     * 更新商品变更记录
     *
     * @param itemChangeApplyReqDto 修改变更申请的参数
     * @return 返回long
     */
    @PutMapping(value = "")
    @ApiOperation(value = "更新商品变更记录", notes = "更新商品变更记录")
    RestResponse<Long> updateItemChangeApply(@Validated @RequestBody ItemChangeApplyReqDto itemChangeApplyReqDto);

}
