package com.dtyunxi.yundt.cube.center.item.api.base.constants;

public enum ShelfStatusEnum {

    WAIT_SHELF(0, "未发布"),
    ON_SHELF(1, "已上架"),
    OFF_SHELF(2, "已下架");

    ShelfStatusEnum(int code, String name) {
        this.code = code;
        this.name = name;
    }

    private int code;

    private String name;

    public static ShelfStatusEnum getByCode(int code) {
        for (ShelfStatusEnum obj : ShelfStatusEnum.values()) {
            if (code == obj.getCode()) {
                return obj;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
