/**
 * @(#) IExampleService.java 1.1.0 2018-08-20
 * <p>
 * Copyright (c)  2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;

/**
 * 商品请求参数Dto
 *
 * @author 佐助
 * @since 2.0.0
 */
@ApiModel(value = "ItemRespDto", description = "商品请求参数Dto")
public class ItemReqDto extends BaseReqDto {

    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
     * 名称
     */
    @ApiModelProperty(name = "name", value = "商品名称")
    private String name;
    /**
     * 商品编码
     */
    @ApiModelProperty(name = "code", value = "商品编码")
    private String code;
    /**
     * 品牌Id
     */
    @ApiModelProperty(name = "brandId", value = "品牌id")
    private Long brandId;

    /**
     * 品牌Id
     */
    @ApiModelProperty(name = "brand", value = "品牌名称")
    private String brand;

    @ApiModelProperty(name = "attrs", value = "商品属性，选填")
    private String attrs;

    /**
     * 品牌Id列表
     */
    @ApiModelProperty(name = "brandIdList", value = "品牌id列表")
    private List<Long> brandIdList;


    /**
     * 虚拟商品
     */
    @ApiModelProperty(name = "vitrual", value = "虚拟商品")
    private Boolean vitrual;
    /**
     * 状态
     */
    @ApiModelProperty(name = "status", value = "状态")
    private Integer status;
    @ApiModelProperty(name = "statusList", value = "状态列表")
    private List<Integer> statusList;
    /**
     * 商品类型: 1-商品  2-产品  默认1 3 -组合商品；
     */
    @ApiModelProperty(name = "type", value = "商品类型:1-商品  2-产品  默认1 3 -组合商品；4 虚拟商品")
    private Integer type;
    /**
     * 商品类型: 1-商品  2-产品  默认1 3 -组合商品；
     */
    @ApiModelProperty(name = "typeList", value = "商品类型列表")
    private List<Integer> typeList;
    /**
     * 创建人
     */
    @ApiModelProperty(name = "ownerId", value = "创建人")
    private Long ownerId;
    /**
     * 商品版本
     */
    @ApiModelProperty(name = "version", value = "商品版本")
    private Long version;
    /**
     * 目录Id
     */
    @ApiModelProperty(name = "dirId", value = "目录Id")
    private Long dirId;

    /**
     * 目录Id列表
     */
    @ApiModelProperty(name = "dirIdList", value = "目录Id列表")
    private List<Long> dirIdList;

    /**
     * 运费模板
     */
    @ApiModelProperty(name = "shippingTpl", value = "运费模板")
    private Long shippingTpl;
    /**
     * 创建开始时间
     */
    @ApiModelProperty(name = "createBeginTime", value = "创建开始时间")
    private String createBeginTime;
    /**
     * 创建结束时间
     */
    @ApiModelProperty(name = "createEndTime", value = "创建结束时间")
    private String createEndTime;
    /**
     * 更新开始时间
     */
    @ApiModelProperty(name = "updateBeginTime", value = "更新开始时间")
    private String updateBeginTime;
    /**
     * 更新结束时间
     */
    @ApiModelProperty(name = "updateEndTime", value = "更新结束时间")
    private String updateEndTime;
    /**
     * 商品ID集合
     */
    @ApiModelProperty(name = "itemIds", value = "商品ID集合")
    private List<Long> itemIds;

    @ApiModelProperty(name = "shopIds", value = "店铺id列表")
    private List<Long> shopIds;

    @ApiModelProperty(name = "sellerId", value = "商户ID")
    private Long sellerId;

    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;

    @ApiModelProperty(name = "spuid", value = "产品id")
    private Long spuid;

    /**
     * 业务类型：0 普通； 1 社区团购  默认0
     */
    @ApiModelProperty(name = "busType", value = "业务类型：0 普通； 1 社区团购  默认0")
    private Integer busType;

    @ApiModelProperty(name = "skuCode", value = "SKU编码")
    private String skuCode;

    @ApiModelProperty(name = "yearBegin", value = "所属年份（起始）")
    private Integer yearBegin;

    @ApiModelProperty(name = "yearEnd", value = "所属年份（结束）")
    private Integer yearEnd;

    @ApiModelProperty(name = "safetyStockBegin", value = "安全库存数(起始)，支持小数点")
    private BigDecimal safetyStockBegin;

    @ApiModelProperty(name = "safetyStockEnd", value = "安全库存数(结束)，支持小数点")
    private BigDecimal safetyStockEnd;

    @ApiModelProperty(name = "priceBegin", value = "单价(起始)")
    private BigDecimal priceBegin;

    @ApiModelProperty(name = "priceEnd", value = "单价(结束)")
    private BigDecimal priceEnd;

    @ApiModelProperty(name = "ifAvailableOffline", value = "是否线下可售，0-否，1-是")
    private Integer ifAvailableOffline;

    @ApiModelProperty(name = "bizType", value = "业务类型，1-商城商品查询，2-商品库商品查询")
    private Integer bizType;

    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;

    @ApiModelProperty(name = "organizationId",value = "组织id")
    private Long organizationId;

    @ApiModelProperty(name = "organizationIdList", value = "组织Id列表")
    private List<Long> organizationIdList;

    @ApiModelProperty(name = "skuIdList", value = "SKUId列表")
    private List<Long> skuIdList;

    @ApiModelProperty(name = "outSkuIdList", value = "在SKUId集合外查询")
    private List<Long> outSkuIdList;

    @ApiModelProperty(name = "subType", value = "商品子类型，1-产品，2-赠品，3-物料")
    private Integer subType;

    @ApiModelProperty(name = "subTypeList", value = "商品子类型，1-产品，2-赠品，3-物料")
    private List<Integer> subTypeList;

    /**
     * 过滤的条件，商品授权专用字段，限制已授权的SKU不出现在列表中，现在暂时只有sku限制过滤，[{"businessType":"SKU", "targetType":1, "targetIdList":[]}]
     */
    @ApiModelProperty(name = "limitList", value = "过滤的条件，商品授权专用字段，限制已授权的SKU不出现在列表中，现在暂时只有sku限制过滤，[{\"businessType\":\"SKU\", \"targetType\":1, \"targetIdList\":[]}]")
    private List<ItemAuthLimitDto> limitList;

    @ApiModelProperty(name = "dosageForm", value = "剂型")
    private String dosageForm;

    @ApiModelProperty(name = "keyword", value = "关键字，支持商品名字/商品编码模糊搜索")
    private String keyword;

    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String getDosageForm() {
        return dosageForm;
    }

    public void setDosageForm(String dosageForm) {
        this.dosageForm = dosageForm;
    }

    public List<ItemAuthLimitDto> getLimitList() {
        return limitList;
    }

    public void setLimitList(List<ItemAuthLimitDto> limitList) {
        this.limitList = limitList;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public List<Integer> getSubTypeList() {
        return subTypeList;
    }

    public void setSubTypeList(List<Integer> subTypeList) {
        this.subTypeList = subTypeList;
    }

    public List<Long> getOutSkuIdList() {
        return outSkuIdList;
    }

    public void setOutSkuIdList(List<Long> outSkuIdList) {
        this.outSkuIdList = outSkuIdList;
    }

    public List<Long> getSkuIdList() {
        return skuIdList;
    }

    public void setSkuIdList(List<Long> skuIdList) {
        this.skuIdList = skuIdList;
    }

    public List<Long> getOrganizationIdList() {
        return organizationIdList;
    }

    public void setOrganizationIdList(List<Long> organizationIdList) {
        this.organizationIdList = organizationIdList;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public List<Long> getShopIds() {
        return shopIds;
    }

    public void setShopIds(List<Long> shopIds) {
        this.shopIds = shopIds;
    }

    public List<Integer> getStatusList() {
        return statusList;
    }

    public void setStatusList(List<Integer> statusList) {
        this.statusList = statusList;
    }

    public List<Integer> getTypeList() {
        return typeList;
    }

    public void setTypeList(List<Integer> typeList) {
        this.typeList = typeList;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }


    public Boolean getVitrual() {
        return vitrual;
    }

    public void setVitrual(Boolean vitrual) {
        this.vitrual = vitrual;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public Long getVersion() {
        return version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public Long getShippingTpl() {
        return shippingTpl;
    }

    public void setShippingTpl(Long shippingTpl) {
        this.shippingTpl = shippingTpl;
    }

    public String getCreateBeginTime() {
        return createBeginTime;
    }

    public void setCreateBeginTime(String createBeginTime) {
        this.createBeginTime = createBeginTime;
    }

    public String getCreateEndTime() {
        return createEndTime;
    }

    public void setCreateEndTime(String createEndTime) {
        this.createEndTime = createEndTime;
    }

    public String getUpdateBeginTime() {
        return updateBeginTime;
    }

    public void setUpdateBeginTime(String updateBeginTime) {
        this.updateBeginTime = updateBeginTime;
    }

    public String getUpdateEndTime() {
        return updateEndTime;
    }

    public void setUpdateEndTime(String updateEndTime) {
        this.updateEndTime = updateEndTime;
    }

    public List<Long> getItemIds() {
        return itemIds;
    }

    public void setItemIds(List<Long> itemIds) {
        this.itemIds = itemIds;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getSpuid() {
        return spuid;
    }

    public void setSpuid(Long spuid) {
        this.spuid = spuid;
    }

    public Integer getBusType() {
        return busType;
    }

    public void setBusType(Integer busType) {
        this.busType = busType;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public Integer getYearBegin() {
        return yearBegin;
    }

    public void setYearBegin(Integer yearBegin) {
        this.yearBegin = yearBegin;
    }

    public Integer getYearEnd() {
        return yearEnd;
    }

    public void setYearEnd(Integer yearEnd) {
        this.yearEnd = yearEnd;
    }

    public BigDecimal getSafetyStockBegin() {
        return safetyStockBegin;
    }

    public void setSafetyStockBegin(BigDecimal safetyStockBegin) {
        this.safetyStockBegin = safetyStockBegin;
    }

    public BigDecimal getSafetyStockEnd() {
        return safetyStockEnd;
    }

    public void setSafetyStockEnd(BigDecimal safetyStockEnd) {
        this.safetyStockEnd = safetyStockEnd;
    }

    public BigDecimal getPriceBegin() {
        return priceBegin;
    }

    public void setPriceBegin(BigDecimal priceBegin) {
        this.priceBegin = priceBegin;
    }

    public BigDecimal getPriceEnd() {
        return priceEnd;
    }

    public void setPriceEnd(BigDecimal priceEnd) {
        this.priceEnd = priceEnd;
    }

    public Integer getIfAvailableOffline() {
        return ifAvailableOffline;
    }

    public void setIfAvailableOffline(Integer ifAvailableOffline) {
        this.ifAvailableOffline = ifAvailableOffline;
    }

    public Integer getBizType() {
        return bizType;
    }

    public void setBizType(Integer bizType) {
        this.bizType = bizType;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public List<Long> getBrandIdList() {
        return brandIdList;
    }

    public void setBrandIdList(List<Long> brandIdList) {
        this.brandIdList = brandIdList;
    }

    public List<Long> getDirIdList() {
        return dirIdList;
    }

    public void setDirIdList(List<Long> dirIdList) {
        this.dirIdList = dirIdList;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getAttrs() {
        return attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }
}
