/*
 * @(#)InventoryException.java 1.0 2018-08-28
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

/**
 * 订单上架入参dto
 *
 * @author 简树
 * @since 2.0.0
 */
@ApiModel(value = "ItemSelfReqDto", description = "商品上架目录实体")
public class ItemShelfReqDto extends BaseReqDto {
    /**
     * skuId
     */
    @ApiModelProperty(name = "skuId", value = "skuId，选填，为空时会上架商品的所有规格，填写为只上架该商品的该规格")
    private Long skuId;
    /**
     * 价格ID
     */
    @ApiModelProperty(name = "priceId", value = "价格ID，选填")
    private Long priceId;
    /**
     * 价格
     */
    @ApiModelProperty(name = "price", value = "价格，选填")
    private BigDecimal price;

    /**
     * 库存
     */
    @ApiModelProperty(name = "storage", value = "库存")
    private Long storage;

    /**
     * 商品别名
     */
    @ApiModelProperty(name = "aliasName", value = "商品别名，选填")
    private String aliasName;
    /**
     * 商品id（必填）
     */
    @NotNull(message = "商品id不能为null")
    @ApiModelProperty(name = "itemId", value = "商品id，必填")
    private Long itemId;
    /**
     * 目录id（非必填，摆放的目录ID）
     */
    @ApiModelProperty(name = "dirId", value = "目录id，必填")
    private Long dirId;
    /**
     * 附加信息
     */
    @ApiModelProperty(name = "extInfo", value = "附加信息，选填")
    private String extInfo;
    /**
     * 店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "店铺ID，必填")
    private Long shopId;
    /**
     * 商户ID
     */
    @ApiModelProperty(name = "sellerId", value = "商户ID，选填")
    private Long sellerId;
    /**
     * 渠道ID
     */
    @ApiModelProperty(name = "channelId", value = "渠道ID，选填")
    private Long channelId;

    @ApiModelProperty(name = "snapshotId", value = "快照ID，选填")
    private Long snapshotId;

    @ApiModelProperty(name = "isTiming", value = "是否定时上架，选填true(定时上架)/false，为true时需要有对应的shelfTimeReqDto数据")
    private boolean isTiming;

    @ApiModelProperty(name = "ShelfTimeReqDto", value = "定时上架任务时间设置dto，选填，isTiming为true需要有对应的数据")
    private ShelfTimeReqDto shelfTimeReqDto;

    @ApiModelProperty(name = "dirType", value = "类目类型")
    private String dirType;

    @ApiModelProperty(name = "type", value = "上架类型：1普通上架 2周期购上架 默认是普通上架")
    private Integer type;

    @ApiModelProperty(name = "itemType", value = "商品类型：同产品库的商品类型")
    private Integer itemType;

    @ApiModelProperty(name = "busType", value = "上架业务类型：0普通商品 2 积分商品")
    private Integer busType;
    /**
     * 兑换金额
     */
    @ApiModelProperty(name = "cashAmount", value = "兑换金额")
    private BigDecimal cashAmount;
    /**
     * 积分
     */
    @ApiModelProperty(name = "cashIntegral", value = "积分")
    private Long cashIntegral;
    /**
     * 兑换数量限制
     */
    @ApiModelProperty(name = "cashLimit", value = "兑换数量限制")
    private Integer cashLimit;
    /**
     * 规则说明
     */
    @ApiModelProperty(name = "ruleRemark", value = "规则说明")
    private String ruleRemark;
    /**
     * 兑换类型：1积分 2积分+金额
     */
    @ApiModelProperty(name = "cashType", value = "兑换类型：1积分2积分+金额")
    private Integer cashType;

    /**
     * 组织Id
     */
    @ApiModelProperty(name = "organizationId", value = "组织Id")
    private Long organizationId;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;

    /**
     * 商品分销设置
     */
    @ApiModelProperty(name = "distributionSet", value = "商品分销设置")
    private DistributionSetReqDto distributionSet;

    @ApiModelProperty(name = "distribution", value = "是否分销：1是，0否, 默认0")
    private Integer distribution = 0;
    @ApiModelProperty(name = "freightTemplateId", value = "运费模板id")
    private Long freightTemplateId;

    @ApiModelProperty(name = "pointsDeduction", value = "是否积分扣减: 1 是, 0 否")
    private Integer pointsDeduction;

    @ApiModelProperty(name = "pointsDeductionRuleReqDto", value = "积分扣减规则")
    private PointsDeductionReqDto pointsDeductionReqDto;

    @ApiModelProperty(name = "bundleItemDtos", value = "组合商品子商品")
    private List<BundleItemReqDto> bundleItemDtos;

    @ApiModelProperty(name = "stockDisplay", value = "库存显示,1:显示可用库存数量;2:显示库存充足;3:不显示库存")
    private Integer stockDisplay;

    @ApiModelProperty(name = "limitMin", value = "起订量;limit_min_mode的值为1就为固定值;2就为最小包装数倍数")
    private Integer limitMin;

    @ApiModelProperty(name = "limitMinMode", value = "起订量计算方式,1:自定义设置(固定值);2:最小包装数倍数(按最小包装数倍数起订，起订量=最小包装数*最小包装数倍数)")
    private Integer limitMinMode;

    @ApiModelProperty(name = "multipleStatus", value = "订购倍数控制,0:关闭;1:开启(开启时，下单商品数量必须等于起订量的倍数)")
    private Integer multipleStatus;

    @ApiModelProperty(name = "homePageDisplay",value = "首页推荐 0 H5商城 1 Web商城(多选用','分割)")
    private String homePageDisplay;

    public Integer getStockDisplay() {
        return stockDisplay;
    }

    public void setStockDisplay(Integer stockDisplay) {
        this.stockDisplay = stockDisplay;
    }

    public Integer getLimitMin() {
        return limitMin;
    }

    public void setLimitMin(Integer limitMin) {
        this.limitMin = limitMin;
    }

    public Integer getLimitMinMode() {
        return limitMinMode;
    }

    public void setLimitMinMode(Integer limitMinMode) {
        this.limitMinMode = limitMinMode;
    }

    public Integer getMultipleStatus() {
        return multipleStatus;
    }

    public void setMultipleStatus(Integer multipleStatus) {
        this.multipleStatus = multipleStatus;
    }

    public List<BundleItemReqDto> getBundleItemDtos() {
        return bundleItemDtos;
    }

    public void setBundleItemDtos(List<BundleItemReqDto> bundleItemDtos) {
        this.bundleItemDtos = bundleItemDtos;
    }

    public PointsDeductionReqDto getPointsDeductionReqDto() {
        return pointsDeductionReqDto;
    }

    public void setPointsDeductionReqDto(PointsDeductionReqDto pointsDeductionReqDto) {
        this.pointsDeductionReqDto = pointsDeductionReqDto;
    }

    public Integer getPointsDeduction() {
        return pointsDeduction;
    }

    public void setPointsDeduction(Integer pointsDeduction) {
        this.pointsDeduction = pointsDeduction;
    }

    public Long getFreightTemplateId() {
        return freightTemplateId;
    }

    public void setFreightTemplateId(Long freightTemplateId) {
        this.freightTemplateId = freightTemplateId;
    }

    public Integer getBusType() {
        return busType;
    }

    public void setBusType(Integer busType) {
        this.busType = busType;
    }

    public Integer getCashType() {
        return cashType;
    }

    public void setCashType(Integer cashType) {
        this.cashType = cashType;
    }

    public Integer getItemType() {
        return itemType;
    }

    public void setItemType(Integer itemType) {
        this.itemType = itemType;
    }

    public String getRuleRemark() {
        return ruleRemark;
    }

    public void setRuleRemark(String ruleRemark) {
        this.ruleRemark = ruleRemark;
    }

    public BigDecimal getCashAmount() {
        return cashAmount;
    }

    public void setCashAmount(BigDecimal cashAmount) {
        this.cashAmount = cashAmount;
    }

    public Long getCashIntegral() {
        return cashIntegral;
    }

    public void setCashIntegral(Long cashIntegral) {
        this.cashIntegral = cashIntegral;
    }

    public Integer getCashLimit() {
        return cashLimit;
    }

    public void setCashLimit(Integer cashLimit) {
        this.cashLimit = cashLimit;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getPriceId() {
        return priceId;
    }

    public void setPriceId(Long priceId) {
        this.priceId = priceId;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Long getStorage() {
        return storage;
    }

    public void setStorage(Long storage) {
        this.storage = storage;
    }

    public boolean isTiming() {
        return isTiming;
    }

    public String getAliasName() {
        return aliasName;
    }

    public void setAliasName(String aliasName) {
        this.aliasName = aliasName;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public String getExtInfo() {
        return extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getSnapshotId() {
        return snapshotId;
    }

    public void setSnapshotId(Long snapshotId) {
        this.snapshotId = snapshotId;
    }

    public ShelfTimeReqDto getShelfTimeReqDto() {
        return shelfTimeReqDto;
    }

    public void setShelfTimeReqDto(ShelfTimeReqDto shelfTimeReqDto) {
        this.shelfTimeReqDto = shelfTimeReqDto;
    }

    public boolean getTiming() {
        return isTiming;
    }

    public void setTiming(boolean timing) {
        isTiming = timing;
    }

    public String getDirType() {
        return dirType;
    }

    public void setDirType(String dirType) {
        this.dirType = dirType;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public DistributionSetReqDto getDistributionSet() {
        return distributionSet;
    }

    public void setDistributionSet(DistributionSetReqDto distributionSet) {
        this.distributionSet = distributionSet;
    }

    public Integer getDistribution() {
        return distribution;
    }

    public void setDistribution(Integer distribution) {
        this.distribution = distribution;
    }

    public String getHomePageDisplay() {
        return homePageDisplay;
    }

    public void setHomePageDisplay(String homePageDisplay) {
        this.homePageDisplay = homePageDisplay;
    }
}