/*
 * @(#)ItemSkuReqDto.java 1.0 2018-09-03
 *
 * 			Copyright (c) 2017, YUNXI. All rights reserved.
 * 			YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * sku查询
 * @author  惜笔 | 林五弟
 * @date  2021/11/18 17:23
 * @version 1.0.0
 */
@Data
@ApiModel(value = "ItemSkuQueryReqDto", description = "sku查询信息dto")
public class ItemSkuQueryReqDto extends BaseReqDto {

    @ApiModelProperty(name = "keyword", value = "支持商品名字，商品编码搜索，模糊匹配")
    private String keyword;

    @ApiModelProperty(name = "itemOrgId", value = "商品所属组织")
    private Long itemOrgId;

    @ApiModelProperty(name = "skuCode", value = "sku编码")
    private String skuCode;

    @ApiModelProperty(name = "skuCodeList", value = "sku编码")
    private List<String> skuCodeList;

    @ApiModelProperty(name = "itemName", value = "商品名字")
    private String itemName;

    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;

    @ApiModelProperty(name = "subType", value = "商品子类型，1-产品，2-赠品，3-物料")
    private Integer subType;

    @ApiModelProperty(name = "brandId", value = "品牌")
    private Long brandId;

    @ApiModelProperty(name = "dirIdList", value = "类目id")
    private List<Long> dirIdList;

    @ApiModelProperty(name = "dirId", value = "类目，支持下级查询")
    private Long dirId;

    @ApiModelProperty(name = "outSkuIdList", value = "移除的skuId")
    private List<Long> outSkuIdList;

    @ApiModelProperty(name = "inSkuIdList", value = "指定的skuId")
    private List<Long> inSkuIdList;

    @ApiModelProperty(name = "channel", value = "渠道，1-平台端，2-大B端", required = true)
    private Integer channel;

    @ApiModelProperty(name = "shopIdList", value = "channel为2时，限制查询sku范围的店铺范围(必填)", hidden = true)
    private List<Long> shopIdList;

    @ApiModelProperty(name = "orgId", value = "登录者组织id", hidden = true)
    private Long orgId;

    @ApiModelProperty(name = "itemLongCode", value = "商品长编码")
    private String itemLongCode;

    @ApiModelProperty(name = "itemLongCodeList", value = "商品长编码")
    private List<String> itemLongCodeList;

    @ApiModelProperty(name = "itemOrgIdList", value = "商品组织id")
    private List<Long> itemOrgIdList;

    @ApiModelProperty(name = "itemCodeList", value = "商品编码集合")
    private List<String> itemCodeList;

    @ApiModelProperty(name = "giftBox", value = "商品礼盒，0-是，1-否")
    private Integer giftBox;

    private List<Long> brandIds;

    public String getItemLongCode() {
        return itemLongCode;
    }

    public void setItemLongCode(String itemLongCode) {
        this.itemLongCode = itemLongCode;
    }

    public List<String> getItemLongCodeList() {
        return itemLongCodeList;
    }

    public void setItemLongCodeList(List<String> itemLongCodeList) {
        this.itemLongCodeList = itemLongCodeList;
    }

    public List<Long> getItemOrgIdList() {
        return itemOrgIdList;
    }

    public void setItemOrgIdList(List<Long> itemOrgIdList) {
        this.itemOrgIdList = itemOrgIdList;
    }

    public List<Long> getShopIdList() {
        return shopIdList;
    }

    public void setShopIdList(List<Long> shopIdList) {
        this.shopIdList = shopIdList;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public List<String> getSkuCodeList() {
        return skuCodeList;
    }

    public void setSkuCodeList(List<String> skuCodeList) {
        this.skuCodeList = skuCodeList;
    }

    public List<Long> getInSkuIdList() {
        return inSkuIdList;
    }

    public void setInSkuIdList(List<Long> inSkuIdList) {
        this.inSkuIdList = inSkuIdList;
    }

    public List<Long> getDirIdList() {
        return dirIdList;
    }

    public void setDirIdList(List<Long> dirIdList) {
        this.dirIdList = dirIdList;
    }

    public Integer getChannel() {
        return channel;
    }

    public void setChannel(Integer channel) {
        this.channel = channel;
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public Long getItemOrgId() {
        return itemOrgId;
    }

    public void setItemOrgId(Long itemOrgId) {
        this.itemOrgId = itemOrgId;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public List<Long> getOutSkuIdList() {
        return outSkuIdList;
    }

    public void setOutSkuIdList(List<Long> outSkuIdList) {
        this.outSkuIdList = outSkuIdList;
    }
}
