/**
 * @(#) ItemStatCreateReqDto.java 1.0 2019-08-05
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 单位时间内商品的销售数量设置Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "ItemStatReqDto", description = "单位时间内商品的销售数量设置Dto")
public class ItemStatReqDto extends BaseReqDto {
    /**
     * 店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "店铺ID，可选")
    private Long shopId;
    /**
     * 商品ID
     */
    @ApiModelProperty(name = "itemId", value = "商品ID，必传")
    private Long itemId;
    /**
     * 销售数量
     */
    @ApiModelProperty(name = "salesCount", value = "销售数量，必传")
    private Long salesCount;
    @ApiModelProperty(name = "itemType", value = "商品类型：1普通商品 2积分商品")
    private Integer itemType;

    public Integer getItemType() {
        return itemType;
    }

    public void setItemType(Integer itemType) {
        this.itemType = itemType;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getSalesCount() {
        return salesCount;
    }

    public void setSalesCount(Long salesCount) {
        this.salesCount = salesCount;
    }
}
