/**
 * @(#) IExampleService.java 1.1.0 2018-08-20
 *
 * Copyright (c)  2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 *  商品标签请求参数Dto
 *
 * @author 佐助
 * @since 2.0.0
 */
@ApiModel(value = "ItemTagReqDto", description = "商品标签请求参数Dto")
public class ItemTagReqDto extends BaseReqDto {

    @ApiModelProperty(name = "id", value = "主键id，新增时选填，修改时必填")
    private Long id;

    /**
     * 标签ID
     */
    @NotNull(message = "标签id不能为空")
    @ApiModelProperty(name = "tagId",value = "标签ID，必填")
    private Long tagId;

    /**
     * 商品ID
     */
    @NotNull(message = "商品id不能为空")
    @ApiModelProperty(name = "itemId",value = "商品ID，必填")
    private Long itemId;

    /**
     * 规格ID
     */
    @ApiModelProperty(name = "skuId",value = "规格ID，选填")
    private Long skuId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getTagId() {
        return tagId;
    }

    public void setTagId(Long tagId) {
        this.tagId = tagId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }
}
