/**
 * @(#)OffItemReqDto 1.0 2019/3/21
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * @author shuangqing  2019/3/21
 */
public class
OffItemReqDto extends BaseReqDto {

    @ApiModelProperty(name = "itemId", value = "商品id，必填")
    private Long itemId;

    @ApiModelProperty(name = "skuId", value = "规格Id，选填，填写时只下架该规格")
    private Long skuId;

    @ApiModelProperty(name = "dirId", value = "目录id，选填，填写时只下架该目录的商品(商品可能会上架在多个目录)")
    private Long dirId;

    @ApiModelProperty(name = "shopId", value = "店铺id，必填")
    private Long shopId;

    @ApiModelProperty(name = "snapshotId", value = "快照id，选填")
    private Long snapshotId;

    @ApiModelProperty(name = "isTiming", value = "是否定时下架 true/false，选填")
    private boolean isTiming;

    @ApiModelProperty(name = "offTime", value = "定时下架时间，选填，配合isTiming使用，当isTiming为true时")
    private Date offTime;
    @ApiModelProperty(name = "itemType", value = "商品类型:1普通商品 2积分商品")
    private Integer itemType;
    @ApiModelProperty(name = "busType", value = "上架业务类型：0普通商品 1社区团购 2 积分商品")
    private Integer busType;

    @ApiModelProperty(name = "shopAuth", value = "商品sku是否已取消店铺授权：0否 1是")
    private Integer shopAuth;

    public Integer getShopAuth() {
        return shopAuth;
    }

    public void setShopAuth(Integer shopAuth) {
        this.shopAuth = shopAuth;
    }

    public Integer getBusType() {
        return busType;
    }

    public void setBusType(Integer busType) {
        this.busType = busType;
    }

    public Integer getItemType() {
        return itemType;
    }

    public void setItemType(Integer itemType) {
        this.itemType = itemType;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getSnapshotId() {
        return snapshotId;
    }

    public void setSnapshotId(Long snapshotId) {
        this.snapshotId = snapshotId;
    }

    public boolean isTiming() {
        return isTiming;
    }

    public void setTiming(boolean timing) {
        isTiming = timing;
    }

    public Date getOffTime() {
        return offTime;
    }

    public void setOffTime(Date offTime) {
        this.offTime = offTime;
    }
}
