/**
 * @(#) ItemAllowOrderRespDto.java 1.0 2019-03-01
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;

import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemAllowOrderDetailQueryRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 检查商品是否在下单时间范围内汇总响应Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "ItemAllowOrderQueryRespDto", description = "检查商品是否在下单时间范围内响应Dto")
public class ItemAllowOrderQueryRespDto extends BaseRespDto {
    /**
     * 是否全部都允许下单(true允许 false不允许)
     */
    @ApiModelProperty(name = "allAllowOrder", value = "是否全部都允许下单(true允许 false不允许)")
    private Boolean allAllowOrder;
    /**
     * 商品是否允许下单数据集合
     */
    @ApiModelProperty(name = "list", value = "商品是否允许下单数据集合")
    private List<ItemAllowOrderDetailQueryRespDto> list;

    public Boolean getAllAllowOrder() {
        return allAllowOrder;
    }

    public void setAllAllowOrder(Boolean allAllowOrder) {
        this.allAllowOrder = allAllowOrder;
    }

    public List<ItemAllowOrderDetailQueryRespDto> getList() {
        return list;
    }

    public void setList(List<ItemAllowOrderDetailQueryRespDto> list) {
        this.list = list;
    }
}
