package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;

import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemChangeApplyDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.Date;


/**
 * 商品版本响应Dto
 *
 * @author 佐助
 * @since 2.0.0
 */
@ApiModel(value = "ItemChangeApplyRespDto", description = "商品版本响应Dto")
public class ItemChangeApplyRespDto extends BaseRespDto {
    /**
     * 变更记录id
     */
    @NotNull(message = "变更记录id不能为null")
    @ApiModelProperty(name = "id", value = "变更记录id")
    private Long id;
    /**
     * 版本编号
     */
    @ApiModelProperty(name = "code", value = "变更记录编号")
    private String code;

    /**
     * 商品Id
     */
    @ApiModelProperty(name = "itemId", value = "商品ID")
    private Long itemId;

    /**
     * 商品名称
     */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;
    /**
     * 商品编码
     */
    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;
    /**
     * 商品类型1普通商品2产品3组合商品 默认1
     */
    @ApiModelProperty(name = "type", value = "商品类型1普通商品2产品3组合商品 默认1")
    private Integer type = 1;
    /**
     * 状态
     */
    @ApiModelProperty(name = "status", value = "状态")
    private Integer status;

    /**
     * 商品快照id
     */
    @ApiModelProperty(name = "snapshotId", value = "商品快照id")
    private Long snapshotId;

    @ApiModelProperty(name = "snapshot", value = "商品快照信息，旧的字段做兼容的存在")
    private String snapshot;

    /**
     * 商品快照信息——存当前快照信息或某个历史快照信息
     * <p>
     * 根据版本id 查询版本信息不需要再调用一个查询快照具体信息接口
     */
    @ApiModelProperty(name = "snapshot", value = "商品快照信息,根据版本id查询需要")
    private ItemChangeApplyDto itemChangeApplyDto;

    /**
     * 应用实例ID
     */
    @NotNull(message = "应用实例ID不能为null")
    @ApiModelProperty(name = "instanceId", value = "应用实例ID", required = true)
    private Long instanceId;
    /**
     * 租户ID
     */
    @ApiModelProperty(name = "tenantId", value = "租户ID")
    private Long tenantId;
    /**
     * 所属人ID
     */
    @NotNull(message = "所属人ID不能为null")
    @ApiModelProperty(name = "ownerId", value = "所属人ID")
    private Long ownerId;
    /**
     * 品牌名称
     */
    @ApiModelProperty(name = "brand", value = "品牌名称")
    private String brand;

    /**
     * 品牌ID
     */
    @ApiModelProperty(name = "brandId", value = "品牌ID")
    private Long brandId;

    /**
     * 目录Id
     */
    @ApiModelProperty(name = "dirId", value = "目录ID")
    private Long dirId;
    /**
     * 目录名称
     */
    @ApiModelProperty(name = "dirName", value = "目录名称")
    private String dirName;
    /**
     * 审核结果
     */
    @ApiModelProperty(name = "result", value = "审核结果")
    private String result;
    /**
     * 审核意见
     */
    @ApiModelProperty(name = "auditDesc", value = "审核意见")
    private String auditDesc;
    /**
     * 审核人ID
     */
    @ApiModelProperty(name = "auditPerson", value = "审核人ID")
    private Long auditPerson;
    /**
     * 审核人名
     */
    @ApiModelProperty(name = "auditPersonName", value = "审核人名")
    private String auditPersonName;
    /**
     * 审核时间
     */
    @ApiModelProperty(name = "auditTime", value = "审核时间")
    private Date auditTime;
    /**
     * 商户ID
     */
    @ApiModelProperty(name = "sellerId", value = "商户ID")
    private Long sellerId;
    /**
     * 店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getSnapshotId() {
        return snapshotId;
    }

    public void setSnapshotId(Long snapshotId) {
        this.snapshotId = snapshotId;
    }

    public String getSnapshot() {
        return snapshot;
    }

    public void setSnapshot(String snapshot) {
        this.snapshot = snapshot;
    }

    public ItemChangeApplyDto getItemChangeApplyDto() {
        return itemChangeApplyDto;
    }

    public void setItemChangeApplyDto(ItemChangeApplyDto itemChangeApplyDto) {
        this.itemChangeApplyDto = itemChangeApplyDto;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public String getDirName() {
        return dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getAuditDesc() {
        return auditDesc;
    }

    public void setAuditDesc(String auditDesc) {
        this.auditDesc = auditDesc;
    }

    public Long getAuditPerson() {
        return auditPerson;
    }

    public void setAuditPerson(Long auditPerson) {
        this.auditPerson = auditPerson;
    }

    public String getAuditPersonName() {
        return auditPersonName;
    }

    public void setAuditPersonName(String auditPersonName) {
        this.auditPersonName = auditPersonName;
    }

    public Date getAuditTime() {
        return auditTime;
    }

    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }
}
