/**
 * @(#) ItemDirQueryRespDto.java 1.0 2018-12-27
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;

import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 商品目录关系响应Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "ItemDirQueryRespDto", description = "商品目录关系响应Dto")
public class ItemDirQueryRespDto extends BaseRespDto {

    /**
     * 商品ID
     */
    @ApiModelProperty(name = "商品ID",value = "itemId")
    private Long itemId;
    /**
     * 关联目录
     */
    @ApiModelProperty(name = "关联目录，关联目录以及查询出父目录",value = "dirList")
    private List<Long> dirList;

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public List<Long> getDirList() {
        return dirList;
    }

    public void setDirList(List<Long> dirList) {
        this.dirList = dirList;
    }
}
