/**
 * @(#) IExampleService.java 1.1.0 2018-08-20
 * <p>
 * Copyright (c)  2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;

import com.dtyunxi.yundt.cube.center.item.api.base.dto.DistributionFeeDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 商品响应Dto
 *
 * @author 佐助
 * @since 2.0.0
 */
@ApiModel(value = "ItemRespDto", description = "商品响应Dto")
public class ItemRespDto extends BaseRespDto {

    private static final long serialVersionUID = -6556019929400468602L;
    @ApiModelProperty(name = "id", value = "id")
    private Long id;
    @ApiModelProperty(name = "itemId", value = "商品ID")
    private Long itemId;
    /**
     * 名称
     */
    @ApiModelProperty(name = "name", value = "商品名称")
    private String name;

    /**
     * 显示名
     */
    @ApiModelProperty(name = "displayName", value = "显示名")
    private String displayName;

    /**
     * 是否礼盒
     */
    @ApiModelProperty(name = "giftBox", value = "是否礼盒（0：是、1：否）")
    private Integer giftBox;

    /**
     * 编码
     */
    @ApiModelProperty(name = "code", value = "编码")
    private String code;

    /**
     * 品牌名称
     */
    @ApiModelProperty(name = "brand", value = "品牌名称")
    private String brand;

    /**
     * 品牌Id
     */
    @ApiModelProperty(name = "brand_id", value = "品牌id")
    private Long brandId;
    /**
     * 虚拟商品
     */
    @ApiModelProperty(name = "vitrual", value = "虚拟商品")
    private Boolean vitrual;

    /**
     * 简介
     */
    @ApiModelProperty(name = "brief", value = "简介")
    private String brief;

    /**
     * 状态
     */
    @ApiModelProperty(name = "status", value = "状态")
    private Integer status;

    /**
     * 退货类型：1不可退 2手动可退 3过期自动退
     */
    @ApiModelProperty(name = "returnType", value = "退货类型：1不可退 2手动可退 3过期自动退")
    private Integer returnType;

    /**
     * 允许退货时间点
     */
    @ApiModelProperty(name = "allowReturnTime", value = "允许退货时间点")
    private String allowReturnTime;

    /**
     * 商品类型: 1-商品  2-产品  默认1 3 -组合商品；
     */
    @ApiModelProperty(name = "type", value = "商品类型:1-商品  2-产品  默认1 3 -组合商品；4虚拟商品")
    private Integer type;


    /**
     * 业务类型：0 普通； 1 社区团购  默认0
     */
    @ApiModelProperty(name = "busType", value = "业务类型：0 普通； 1 社区团购 2 积分商品 默认0")
    private Integer busType;

    /**
     * 产品id
     */
    @ApiModelProperty(name = "spuId", value = "产品id")
    private Long spuid;

    /**
     * 应用实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "应用实例ID")
    private Long instanceId;

    /**
     * 创建人
     */
    @ApiModelProperty(name = "ownerId", value = "创建人")
    private Long ownerId;

    /**
     * 商品版本
     */
    @ApiModelProperty(name = "version", value = "商品版本")
    private Long version;

    /**
     * 详情
     */
    @ApiModelProperty(name = "detail", value = "详情")
    private String detail;

    /**
     * 可卖数量
     */
    @ApiModelProperty(name = "shelfAmount", value = "可卖数量=所有规格的可卖数量之和")
    private Long shelfAmount;

    /**
     * 目录Id
     */
    @ApiModelProperty(name = "dirId", value = "后台列木Id")
    private Long dirId;

    @ApiModelProperty(name = "dirName", value = "后台类目名称")
    private String dirName;

    /**
     * 租户ID
     */
    @ApiModelProperty(name = "tenantId", value = "租户ID")
    private Long tenantId;



    /**
     * 商品价格
     */
    @ApiModelProperty(name = "price", value = "商品价格")
    private List<ItemPriceRespDto> priceRespDtoList;

    /**
     * SKU列表
     */
    @ApiModelProperty(name = "itemSkuList", value = "SKU列表")
    private List<ItemSkuRespDto> itemSkuList;

    /**
     * 多媒体列表
     */
    @ApiModelProperty(name = "itemMediasList", value = "多媒体列表")
    private List<ItemMediasRespDto> itemMediasList;

    /**
     * 商品目录
     */
    @ApiModelProperty(name = "dirsItemsList", value = "商品目录")
    private List<DirsItemsRespDto> dirsItemsList = Lists.newArrayList();

    /**
     * 商品店铺
     */
	@ApiModelProperty(name = "itemShopList", value = "商品店铺")
    private List<ItemShopRespDto> itemShopList;

    /**
     * 排序Key
     */
    @ApiModelProperty(name = "groupKey", value = "排序Key")
    private String  groupKey;

    @ApiModelProperty(name = "itemPropRelationRespDtos", value = "商品属性关联dto")
    private List<ItemPropRelationRespDto> itemPropRelationRespDtos;
    @ApiModelProperty(name = "ruleRemark", value = "规则说明")
    private String ruleRemark;
    /**
     * 兑换类型：1积分 2积分+金额
     */
    @ApiModelProperty(name = "cashType", value = "兑换类型：1积分2积分+金额")
    private Integer cashType;
    @ApiModelProperty(name = "isAfterSale", value = "是否需要售后: 0否 1 是")
    private Integer isAfterSale;

    @ApiModelProperty(name = "itemShelfInfoList", value = "上架数据")
    private List<ItemShelfRespDto> itemShelfInfoList;

    @ApiModelProperty(name = "sellerId", value = "商户ID")
    private Long sellerId;

    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;

    @ApiModelProperty(name = "snapshotId", value = "快照ID")
    private Long snapshotId;

    @ApiModelProperty(name = "shelfTaskDtoList", value = "定时任务列表")
    private List<ShelfTaskRespDto> shelfTaskRespDtoList = Lists.newArrayList();

    @ApiModelProperty(name = "salesCount", value = "统计的售卖数量")
    private Long salesCount;

    @ApiModelProperty(name = "searchAttr", value = "构建ES搜索属性，key有name和value，分别是名称和值")
    private List<Map<String, String>> searchAttr;

    @ApiModelProperty(name = "maxPrice", value = "最大售价")
    private Double maxPrice;

    @ApiModelProperty(name = "minPrice", value = "最小售价")
    private Double minPrice;

    /**
     * 供应商Id
     */
    @ApiModelProperty(name = "supplierId", value = "供应商id")
    private Long supplierId;

    @ApiModelProperty(name = "year", value = "所属年份")
    private Integer year;

    @ApiModelProperty(name = "saleChannel", value = "可售渠道,多个用英文逗号隔开,如：JD,TM")
    private String saleChannel;
    @ApiModelProperty(name = "shelfType", value = "上架类型：1普通上架，2周期购商品上架")
    private Integer shelfType;

    /**
     * 组织id
     */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "组织名称，选填")
    private String organizationName;

    /**
     * 零售限购周期
     */
    @ApiModelProperty(name = "retailLimitPeriod", value = "零售限购周期")
    private String retailLimitPeriod;
    /**
     * 零售限购
     */
    @ApiModelProperty(name = "retailLimit", value = "零售限购")
    private String retailLimit;
    /**
     * 最小起售量（单次购买）
     */
    @ApiModelProperty(name = "retailLimitMin", value = "最小起售量（单次购买）")
    private String retailLimitMin;
    /**
     * 最大零售量（单次购买）
     */
    @ApiModelProperty(name = "retailLimitMax", value = "最大零售量（单次购买）")
    private String retailLimitMax;
    /**
     * 订货限购周期
     */
    @ApiModelProperty(name = "wholesaleLimitPeriod", value = "订货限购周期")
    private String wholesaleLimitPeriod;
    /**
     * 订货限购
     */
    @ApiModelProperty(name = "wholesaleLimit", value = "订货限购")
    private String wholesaleLimit;
    /**
     * 最小订货量（单次购买）
     */
    @ApiModelProperty(name = "wholesaleLimitMin", value = "最小订货量（单次购买）")
    private String wholesaleLimitMin;
    /**
     * 最大订货量（单次购买）
     */
    @ApiModelProperty(name = "wholesaleLimitMax", value = "最大订货量（单次购买）")
    private String wholesaleLimitMax;

    @ApiModelProperty(name = "distributionFeeList", value = "分销佣金列表")
    private List<DistributionFeeDto> distributionFeeList;

    @ApiModelProperty(name = "distribution", value = "是否分销：1是，0否")
    private Integer distribution;

    @ApiModelProperty(name = "distribution", value = "分销佣金")
    private BigDecimal distributionFee;

    @ApiModelProperty(name = "purchaseNum", value = "购买次数")
    private Long purchaseNum;

    @ApiModelProperty(name = "itemBCId", value = "浏览或收藏商品项id")
    private Long itemBCId;

    @ApiModelProperty(name = "itemBCTime", value = "浏览或收藏商品时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date itemBCTime;

    @ApiModelProperty(name = "mainPic", value = "商品主图")
    private String mainPic;

    @ApiModelProperty(name = "pointsDeduction", value = "是否积分扣减: 1 是, 0 否")
    private Integer pointsDeduction;

    @ApiModelProperty( value = "店铺类目ID")
    private Long shopDirId;

    @ApiModelProperty( value = "店铺类目名称")
    private String shopDirName;

    @ApiModelProperty(name = "subType", value = "商品子类型，1-产品，2-赠品，3-物料")
    private Integer subType;

    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;

    @ApiModelProperty(name = "dirIdList", value = "后端类目id集合：[1级，2级，3级]形式")
    private List<Long> dirIdList;

    @ApiModelProperty(name = "dirNameList", value = "后端类目名称集合：[1级，2级，3级]形式")
    private List<String> dirNameList;

    @ApiModelProperty(name = "dosageForm", value = "剂型")
    private String dosageForm;

    @ApiModelProperty(name = "skuId", value = "skuId")
    private Long skuId;

    public String getDosageForm() {
        return dosageForm;
    }

    public void setDosageForm(String dosageForm) {
        this.dosageForm = dosageForm;
    }

    public List<Long> getDirIdList() {
        return dirIdList;
    }

    public void setDirIdList(List<Long> dirIdList) {
        this.dirIdList = dirIdList;
    }

    public List<String> getDirNameList() {
        return dirNameList;
    }

    public void setDirNameList(List<String> dirNameList) {
        this.dirNameList = dirNameList;
    }

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public Integer getPointsDeduction() {
        return pointsDeduction;
    }

    public void setPointsDeduction(Integer pointsDeduction) {
        this.pointsDeduction = pointsDeduction;
    }

    public Long getPurchaseNum() {
        return purchaseNum;
    }

    public void setPurchaseNum(Long purchaseNum) {
        this.purchaseNum = purchaseNum;
    }

    public String getRetailLimitPeriod() {
        return retailLimitPeriod;
    }

    public void setRetailLimitPeriod(String retailLimitPeriod) {
        this.retailLimitPeriod = retailLimitPeriod;
    }

    public String getRetailLimit() {
        return retailLimit;
    }

    public void setRetailLimit(String retailLimit) {
        this.retailLimit = retailLimit;
    }

    public String getRetailLimitMin() {
        return retailLimitMin;
    }

    public void setRetailLimitMin(String retailLimitMin) {
        this.retailLimitMin = retailLimitMin;
    }

    public String getRetailLimitMax() {
        return retailLimitMax;
    }

    public void setRetailLimitMax(String retailLimitMax) {
        this.retailLimitMax = retailLimitMax;
    }

    public String getWholesaleLimitPeriod() {
        return wholesaleLimitPeriod;
    }

    public void setWholesaleLimitPeriod(String wholesaleLimitPeriod) {
        this.wholesaleLimitPeriod = wholesaleLimitPeriod;
    }

    public String getWholesaleLimit() {
        return wholesaleLimit;
    }

    public void setWholesaleLimit(String wholesaleLimit) {
        this.wholesaleLimit = wholesaleLimit;
    }

    public String getWholesaleLimitMin() {
        return wholesaleLimitMin;
    }

    public void setWholesaleLimitMin(String wholesaleLimitMin) {
        this.wholesaleLimitMin = wholesaleLimitMin;
    }

    public String getWholesaleLimitMax() {
        return wholesaleLimitMax;
    }

    public void setWholesaleLimitMax(String wholesaleLimitMax) {
        this.wholesaleLimitMax = wholesaleLimitMax;
    }


    public Integer getShelfType() {
        return shelfType;
    }

    public void setShelfType(Integer shelfType) {
        this.shelfType = shelfType;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public Boolean getVitrual() {
        return vitrual;
    }

    public void setVitrual(Boolean vitrual) {
        this.vitrual = vitrual;
    }

    public String getBrief() {
        return brief;
    }

    public void setBrief(String brief) {
        this.brief = brief;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getReturnType() {
        return returnType;
    }

    public void setReturnType(Integer returnType) {
        this.returnType = returnType;
    }

    public String getAllowReturnTime() {
        return allowReturnTime;
    }

    public void setAllowReturnTime(String allowReturnTime) {
        this.allowReturnTime = allowReturnTime;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Long getSpuid() {
        return spuid;
    }

    public void setSpuid(Long spuid) {
        this.spuid = spuid;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public Long getVersion() {
        return version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }


    public String getDetail() {
        return detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public Long getShelfAmount() {
        return shelfAmount;
    }

    public void setShelfAmount(Long shelfAmount) {
        this.shelfAmount = shelfAmount;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public List<ItemSkuRespDto> getItemSkuList() {
        return itemSkuList;
    }

    public List<ItemPriceRespDto> getPriceRespDtoList() {
        return priceRespDtoList;
    }

    public void setPriceRespDtoList(List<ItemPriceRespDto> priceRespDtoList) {
        this.priceRespDtoList = priceRespDtoList;
    }

    public void setItemSkuList(List<ItemSkuRespDto> itemSkuList) {
        this.itemSkuList = itemSkuList;
    }

    public List<ItemMediasRespDto> getItemMediasList() {
        return itemMediasList;
    }

    public void setItemMediasList(List<ItemMediasRespDto> itemMediasList) {
        this.itemMediasList = itemMediasList;
    }

    public List<DirsItemsRespDto> getDirsItemsList() {
        return dirsItemsList;
    }

    public void setDirsItemsList(List<DirsItemsRespDto> dirsItemsList) {
        this.dirsItemsList = dirsItemsList;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getSnapshotId() {
        return snapshotId;
    }

    public void setSnapshotId(Long snapshotId) {
        this.snapshotId = snapshotId;
    }

    public List<ShelfTaskRespDto> getShelfTaskRespDtoList() {
        return shelfTaskRespDtoList;
    }

    public void setShelfTaskRespDtoList(List<ShelfTaskRespDto> shelfTaskRespDtoList) {
        this.shelfTaskRespDtoList = shelfTaskRespDtoList;
    }

    public Long getSalesCount() {
        return salesCount;
    }

    public void setSalesCount(Long salesCount) {
        this.salesCount = salesCount;
    }

    public List<Map<String, String>> getSearchAttr() {
        return searchAttr;
    }

    public void setSearchAttr(List<Map<String, String>> searchAttr) {
        this.searchAttr = searchAttr;
    }

    public Double getMaxPrice() {
        return maxPrice;
    }

    public void setMaxPrice(Double maxPrice) {
        this.maxPrice = maxPrice;
    }

    public Double getMinPrice() {
        return minPrice;
    }

    public void setMinPrice(Double minPrice) {
        this.minPrice = minPrice;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public Integer getBusType() {
        return busType;
    }

    public void setBusType(Integer busType) {
        this.busType = busType;
    }

    public Integer getYear() {
        return year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public String getSaleChannel() {
        return saleChannel;
    }

    public void setSaleChannel(String saleChannel) {
        this.saleChannel = saleChannel;
    }

    public List<ItemShopRespDto> getItemShopList() {
        return itemShopList;
    }
    public void setItemShopList(List<ItemShopRespDto> itemShopList) {
        this.itemShopList = itemShopList;
    }
    public String getGroupKey() {
        return groupKey;
    }
    public void setGroupKey(String groupKey) {
        this.groupKey = groupKey;
    }

    public String getDirName() {
        return dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public List<DistributionFeeDto> getDistributionFeeList() {
        return distributionFeeList;
    }

    public void setDistributionFeeList(List<DistributionFeeDto> distributionFeeList) {
        this.distributionFeeList = distributionFeeList;
    }

    public BigDecimal getDistributionFee() {
        return distributionFee;
    }

    public void setDistributionFee(BigDecimal distributionFee) {
        this.distributionFee = distributionFee;
    }
    public List<ItemShelfRespDto> getItemShelfInfoList() {
        return itemShelfInfoList;
    }

    public void setItemShelfInfoList(List<ItemShelfRespDto> itemShelfInfoList) {
        this.itemShelfInfoList = itemShelfInfoList;
    }

    public Integer getIsAfterSale() {
        return isAfterSale;
    }

    public void setIsAfterSale(Integer isAfterSale) {
        this.isAfterSale = isAfterSale;
    }

    public Integer getCashType() {
        return cashType;
    }

    public void setCashType(Integer cashType) {
        this.cashType = cashType;
    }

    public String getRuleRemark() {
        return ruleRemark;
    }

    public void setRuleRemark(String ruleRemark) {
        this.ruleRemark = ruleRemark;
    }

    public List<ItemPropRelationRespDto> getItemPropRelationRespDtos() {
        return itemPropRelationRespDtos;
    }

    public void setItemPropRelationRespDtos(List<ItemPropRelationRespDto> itemPropRelationRespDtos) {
        this.itemPropRelationRespDtos = itemPropRelationRespDtos;
    }

    public Integer getDistribution() {
        return distribution;
    }

    public void setDistribution(Integer distribution) {
        this.distribution = distribution;
    }

    public Long getItemBCId() {
        return itemBCId;
    }

    public void setItemBCId(Long itemBCId) {
        this.itemBCId = itemBCId;
    }

    public Date getItemBCTime() {
        return itemBCTime;
    }

    public void setItemBCTime(Date itemBCTime) {
        this.itemBCTime = itemBCTime;
    }

    public String getMainPic() {
        return mainPic;
    }

    public void setMainPic(String mainPic) {
        this.mainPic = mainPic;
    }

    public Long getShopDirId() {
        return shopDirId;
    }

    public void setShopDirId(Long shopDirId) {
        this.shopDirId = shopDirId;
    }

    public String getShopDirName() {
        return shopDirName;
    }

    public void setShopDirName(String shopDirName) {
        this.shopDirName = shopDirName;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }

    public Integer getGiftBox() {
        return giftBox;
    }

    public void setGiftBox(Integer giftBox) {
        this.giftBox = giftBox;
    }
}
