/*
 * @(#)ItemSkuRespDto.java 1.0 2018-09-03
 *
 * 			Copyright (c) 2017, YUNXI. All rights reserved.
 * 			YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;

import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;

/**
 * 商品规格Dto
 *
 * @author 诺克
 * @since 2.0.0
 */
@ApiModel(value = "ItemSkuRespDto", description = "商品规格Dto")
public class ItemSkuRespDto extends BaseRespDto {

    @ApiModelProperty(name = "id", value = "id")
    private Long id;

    @ApiModelProperty(name = "code", value = "编码")
    private String code;

    @ApiModelProperty(name = "name", value = "规格名")
    private String name;

    @ApiModelProperty(name = "cspuid", value = "产品规格")
    private Long cspuid;

    @ApiModelProperty(name = "attr", value = "属性")
    private String attr;

    @ApiModelProperty(name = "status", value = "状态")
    private Integer status;

    @ApiModelProperty(name = "unit", value = "单位")
    private String unit;

    @ApiModelProperty(name = "barCode", value = "识别条形码")
    private String barCode;

    @ApiModelProperty(name = "bundles", value = "组合信息")
    private String bundles;

    @ApiModelProperty(name = "effectiveStartTime", value = "有效的起始时间（例12:00）,有效日期上架当天")
    private String effectiveStartTime;

    @ApiModelProperty(name = "effectiveEndTime", value = "有效的结束时间（例13:00）,有效日期上架当天")
    private String effectiveEndTime;

    @ApiModelProperty(name = "inventoryQuantity", value = "虚拟商品库存数量")
    private Long inventoryQuantity;

    @ApiModelProperty(name = "advanceSale", value = "是否预售(1是 2否)")
    private Integer advanceSale;

    @ApiModelProperty(name = "discontinuationDate", value = "停售日期")
    private String discontinuationDate;

    @ApiModelProperty(name = "instanceId", value = "应用实例ID")
    private Long instanceId;

    @ApiModelProperty(name = "outterCode", value = "外部编码")
    private String outterCode;

    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;

    @ApiModelProperty(name = "itemId", value = "商品id")
    private Long itemId;

    @ApiModelProperty(name = "shelfAmount", value = "可卖数量=所有规格的可卖数量之和")
    private Long shelfAmount;

    @ApiModelProperty(name = "balance", value = "库存数量")
    private Long balance;

    @ApiModelProperty(name = "itemPriceList", value = "价格列表")
    private List<ItemPriceRespDto> itemPriceList = Lists.newArrayList();

    @ApiModelProperty(name = "bundleItemList", value = "组合商品信息")
    private List<BundleItemRespDto> bundleItemList = Lists.newArrayList();

    @ApiModelProperty(name = "medias", value = "商品sku的多媒体信息，选填")
    private List<ItemMediasRespDto> medias = Lists.newArrayList();

    @ApiModelProperty(name = "ifAvailableOffline", value = "是否线下可售，0-否，1-是")
    private Integer ifAvailableOffline;

    @ApiModelProperty(name = "safetyStock", value = "安全库存数")
    private Integer safetyStock;

    @ApiModelProperty(name = "price", value = "定价")
    private BigDecimal price;

    @ApiModelProperty(name = "salePrice", value = "零售价")
    private BigDecimal salePrice;

    /**
     * 退换数量限制
     */
    @ApiModelProperty(name = "cashLimit", value = "积分兑换数量限制")
    private Integer cashLimit;
    /**
     * 退换金额
     */
    @ApiModelProperty(name = "cashAmount", value = "积分兑换金额")
    private BigDecimal cashAmount;
    /**
     * 积分
     */
    @ApiModelProperty(name = "cashIntegral", value = "积分")
    private Long cashIntegral;
    /**
     * 兑换类型：1积分 2积分+金额
     */
    @ApiModelProperty(name = "cashType", value = "兑换类型：1积分2积分+金额")
    private Integer cashType;

    /**
     * 毛重
     */
    @ApiModelProperty(name="grossWeight", value = "毛重")
    private BigDecimal grossWeight;

    /**
     * 毛重单位
     */
    @ApiModelProperty(name="grossWeightUnit", value = "毛重单位")
    private String grossWeightUnit;

    /**
     * 净重
     */
    @ApiModelProperty(name="netWeight", value = "净重")
    private BigDecimal netWeight;

    /**
     * 净重单位
     */
    @ApiModelProperty(name="netWeightUnit", value = "净重单位")
    private String netWeightUnit;

    @ApiModelProperty(name = "distribution", value = "是否分销：1是，0否")
    private Integer distribution;

    @ApiModelProperty(name = "distribution", value = "分销佣金")
    private BigDecimal distributionFee;
    /**
     * 体积
     */
    @ApiModelProperty(name="volume", value = "体积")
    private BigDecimal volume;
    /**
     * 体积单位
     */
    @ApiModelProperty(name="volumeUnit", value = "体积单位")
    private String volumeUnit;
    @ApiModelProperty(name = "freightTemplateId", value = "运费模板id")
    private Long freightTemplateId;
    @ApiModelProperty(name = "freightTemplateName", value = "运费名称")
    private String freightTemplateName;

    @ApiModelProperty(name = "PointsDeductionRespDto", value = "积分扣减规则")
    private PointsDeductionRespDto pointsDeductionRespDto;

    @ApiModelProperty(name = "costPrice",value = "成本价")
    private BigDecimal costPrice;

    @ApiModelProperty(name = "addPriceStatus",value = "0:关闭加价限制;1:开启加价限制")
    private Integer addPriceStatus;
    /**
     * 加价限制设置关闭则不显示
     * @return
     */
    @ApiModelProperty(name = "addPriceMode",value = "加价方式,0:使用默认值;1:自定义比例;2:自定义设置(固定值)")
    private Integer addPriceMode;

    @ApiModelProperty(name = "addPriceMin",value = "限制加价下限;addPriceMod的值为0,1就位百分比;2为固定值(单位元)")
    private String addPriceMin;

    @ApiModelProperty(name = "addPriceMax",value = "限制加价上限")
    private String addPriceMax;

    @ApiModelProperty(name = "shoppingCartItemId",value = "小b端专用，购物车id")
    private Long shoppingCartItemId;

    @ApiModelProperty(name = "shoppingCartItemNum",value = "小b端专用，购物车的数量")
    private Integer shoppingCartItemNum;

    @ApiModelProperty(name = "minPackage",value = "最小包装数")
    private Integer minPackage;

    @ApiModelProperty(name = "stockDisplay", value = "库存显示,1:显示可用库存数量;2:显示库存充足;3:不显示库存")
    private Integer stockDisplay;

    @ApiModelProperty(name = "limitMin", value = "起订量;limit_min_mode的值为1就为固定值;2就为最小包装数倍数")
    private Integer limitMin;

    @ApiModelProperty(name = "limitMinMode", value = "起订量计算方式,1:自定义设置(固定值);2:最小包装数倍数(按最小包装数倍数起订，起订量=最小包装数*最小包装数倍数)")
    private Integer limitMinMode;

    @ApiModelProperty(name = "multipleStatus", value = "订购倍数控制,0:关闭;1:开启(开启时，下单商品数量必须等于起订量的倍数)")
    private Integer multipleStatus;

    @ApiModelProperty(name = "shopId",value = "店铺ID")
    private Long shopId;

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Integer getStockDisplay() {
        return stockDisplay;
    }

    public void setStockDisplay(Integer stockDisplay) {
        this.stockDisplay = stockDisplay;
    }

    public Integer getLimitMin() {
        return limitMin;
    }

    public void setLimitMin(Integer limitMin) {
        this.limitMin = limitMin;
    }

    public Integer getLimitMinMode() {
        return limitMinMode;
    }

    public void setLimitMinMode(Integer limitMinMode) {
        this.limitMinMode = limitMinMode;
    }

    public Integer getMultipleStatus() {
        return multipleStatus;
    }

    public void setMultipleStatus(Integer multipleStatus) {
        this.multipleStatus = multipleStatus;
    }

    public Integer getMinPackage() {
        return minPackage;
    }

    public void setMinPackage(Integer minPackage) {
        this.minPackage = minPackage;
    }

    public Long getShoppingCartItemId() {
        return shoppingCartItemId;
    }

    public void setShoppingCartItemId(Long shoppingCartItemId) {
        this.shoppingCartItemId = shoppingCartItemId;
    }

    public Integer getShoppingCartItemNum() {
        return shoppingCartItemNum;
    }

    public void setShoppingCartItemNum(Integer shoppingCartItemNum) {
        this.shoppingCartItemNum = shoppingCartItemNum;
    }

    public BigDecimal getCostPrice() {
        return costPrice;
    }

    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }

    public Integer getAddPriceStatus() {
        return addPriceStatus;
    }

    public void setAddPriceStatus(Integer addPriceStatus) {
        this.addPriceStatus = addPriceStatus;
    }

    public Integer getAddPriceMode() {
        return addPriceMode;
    }

    public void setAddPriceMode(Integer addPriceMode) {
        this.addPriceMode = addPriceMode;
    }

    public String getAddPriceMin() {
        return addPriceMin;
    }

    public void setAddPriceMin(String addPriceMin) {
        this.addPriceMin = addPriceMin;
    }

    public String getAddPriceMax() {
        return addPriceMax;
    }

    public void setAddPriceMax(String addPriceMax) {
        this.addPriceMax = addPriceMax;
    }

    public PointsDeductionRespDto getPointsDeductionRespDto() {
        return pointsDeductionRespDto;
    }

    public void setPointsDeductionRespDto(PointsDeductionRespDto pointsDeductionRespDto) {
        this.pointsDeductionRespDto = pointsDeductionRespDto;
    }

    public Long getFreightTemplateId() {
        return freightTemplateId;
    }

    public void setFreightTemplateId(Long freightTemplateId) {
        this.freightTemplateId = freightTemplateId;
    }

    public String getFreightTemplateName() {
        return freightTemplateName;
    }

    public void setFreightTemplateName(String freightTemplateName) {
        this.freightTemplateName = freightTemplateName;
    }

    public BigDecimal getVolume() {
        return volume;
    }

    public void setVolume(BigDecimal volume) {
        this.volume = volume;
    }

    public String getVolumeUnit() {
        return volumeUnit;
    }

    public void setVolumeUnit(String volumeUnit) {
        this.volumeUnit = volumeUnit;
    }

    public Integer getCashLimit() {
        return cashLimit;
    }

    public void setCashLimit(Integer cashLimit) {
        this.cashLimit = cashLimit;
    }

    public BigDecimal getCashAmount() {
        return cashAmount;
    }

    public void setCashAmount(BigDecimal cashAmount) {
        this.cashAmount = cashAmount;
    }


    public Long getCashIntegral() {
        return cashIntegral;
    }

    public void setCashIntegral(Long cashIntegral) {
        this.cashIntegral = cashIntegral;
    }

    public Integer getCashType() {
        return cashType;
    }

    public void setCashType(Integer cashType) {
        this.cashType = cashType;
    }

    public BigDecimal getGrossWeight() {
        return grossWeight;
    }

    public void setGrossWeight(BigDecimal grossWeight) {
        this.grossWeight = grossWeight;
    }

    public String getGrossWeightUnit() {
        return grossWeightUnit;
    }

    public void setGrossWeightUnit(String grossWeightUnit) {
        this.grossWeightUnit = grossWeightUnit;
    }

    public BigDecimal getNetWeight() {
        return netWeight;
    }

    public void setNetWeight(BigDecimal netWeight) {
        this.netWeight = netWeight;
    }

    public String getNetWeightUnit() {
        return netWeightUnit;
    }

    public void setNetWeightUnit(String netWeightUnit) {
        this.netWeightUnit = netWeightUnit;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getSalePrice() {
        return salePrice;
    }

    public void setSalePrice(BigDecimal salePrice) {
        this.salePrice = salePrice;
    }

    public Long getBalance() {
        return balance;
    }

    public void setBalance(Long balance) {
        this.balance = balance;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getCspuid() {
        return cspuid;
    }

    public void setCspuid(Long cspuid) {
        this.cspuid = cspuid;
    }

    public String getAttr() {
        return attr;
    }

    public void setAttr(String attr) {
        this.attr = attr;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getBarCode() {
        return barCode;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }

    public String getBundles() {
        return bundles;
    }

    public void setBundles(String bundles) {
        this.bundles = bundles;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public List<ItemPriceRespDto> getItemPriceList() {
        return itemPriceList;
    }

    public void setItemPriceList(List<ItemPriceRespDto> itemPriceList) {
        this.itemPriceList = itemPriceList;
    }

    public List<BundleItemRespDto> getBundleItemList() {
        return bundleItemList;
    }

    public void setBundleItemList(List<BundleItemRespDto> bundleItemList) {
        this.bundleItemList = bundleItemList;
    }

    public List<ItemMediasRespDto> getMedias() {
        return medias;
    }

    public void setMedias(List<ItemMediasRespDto> medias) {
        this.medias = medias;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getShelfAmount() {
        return shelfAmount;
    }

    public void setShelfAmount(Long shelfAmount) {
        this.shelfAmount = shelfAmount;
    }

    public String getOutterCode() {
        return outterCode;
    }

    public void setOutterCode(String outterCode) {
        this.outterCode = outterCode;
    }

    public String getEffectiveStartTime() {
        return effectiveStartTime;
    }

    public void setEffectiveStartTime(String effectiveStartTime) {
        this.effectiveStartTime = effectiveStartTime;
    }

    public String getEffectiveEndTime() {
        return effectiveEndTime;
    }

    public void setEffectiveEndTime(String effectiveEndTime) {
        this.effectiveEndTime = effectiveEndTime;
    }

    public Long getInventoryQuantity() {
        return inventoryQuantity;
    }

    public void setInventoryQuantity(Long inventoryQuantity) {
        this.inventoryQuantity = inventoryQuantity;
    }

    public Integer getAdvanceSale() {
        return advanceSale;
    }

    public void setAdvanceSale(Integer advanceSale) {
        this.advanceSale = advanceSale;
    }

    public String getDiscontinuationDate() {
        return discontinuationDate;
    }

    public void setDiscontinuationDate(String discontinuationDate) {
        this.discontinuationDate = discontinuationDate;
    }

    public Integer getIfAvailableOffline() {
        return ifAvailableOffline;
    }

    public void setIfAvailableOffline(Integer ifAvailableOffline) {
        this.ifAvailableOffline = ifAvailableOffline;
    }

    public Integer getSafetyStock() {
        return safetyStock;
    }

    public void setSafetyStock(Integer safetyStock) {
        this.safetyStock = safetyStock;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public Integer getDistribution() {
        return distribution;
    }

    public void setDistribution(Integer distribution) {
        this.distribution = distribution;
    }

    public BigDecimal getDistributionFee() {
        return distributionFee;
    }

    public void setDistributionFee(BigDecimal distributionFee) {
        this.distributionFee = distributionFee;
    }

}
