/**
 * @(#) ItemStorageQueryRespDto.java 1.0 2018-12-04
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 商品库存响应Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "ItemStorageQueryRespDto", description = "商品库存响应Dto")
public class ItemStorageQueryRespDto extends BaseRespDto {

    /**
     * 店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;
    /**
     * skuId
     */
    @ApiModelProperty(name = "skuId", value = "skuId")
    private Long skuId;
    /**
     * 可用库存数量
     */
    @ApiModelProperty(name = "avaNum", value = "可用库存数量")
    private Long avaNum;
    /**
     * 库存有效日期(今天 未来 yyyy-MM-dd)
     */
    @ApiModelProperty(name = "inventoryEffectiveDate", value = "库存有效日期(今天 未来 yyyy-MM-dd)")
    private String inventoryEffectiveDate;
    @ApiModelProperty(name = "itemShelfRespDto", value = "上架信息")
    private ItemShelfRespDto itemShelfRespDto;

    public ItemShelfRespDto getItemShelfRespDto() {
        return itemShelfRespDto;
    }

    public void setItemShelfRespDto(ItemShelfRespDto itemShelfRespDto) {
        this.itemShelfRespDto = itemShelfRespDto;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getAvaNum() {
        return avaNum;
    }

    public void setAvaNum(Long avaNum) {
        this.avaNum = avaNum;
    }

    public String getInventoryEffectiveDate() {
        return inventoryEffectiveDate;
    }

    public void setInventoryEffectiveDate(String inventoryEffectiveDate) {
        this.inventoryEffectiveDate = inventoryEffectiveDate;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
